/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.micaxs.smokeleaf.screen.custom.GeneratorMenu;
import net.micaxs.smokeleaf.screen.renderer.EnergyDisplayTooltipArea;
import net.micaxs.smokeleaf.utils.MouseUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GeneratorScreen
extends AbstractContainerScreen<GeneratorMenu> {
    public static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"textures/gui/generator/generator_gui.png");
    public static final ResourceLocation LIT_PROGRESS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"container/furnace/lit_progress");
    private EnergyDisplayTooltipArea energyInfoArea;
    private static final ResourceLocation INFO_ICON = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"textures/gui/icons/info.png");
    private static final int ICON_SIZE = 8;
    private static final float TOOLTIP_SCALE = 0.5f;

    public GeneratorScreen(GeneratorMenu menu, Inventory playerInvetory, Component title) {
        super((AbstractContainerMenu)menu, playerInvetory, title);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 100000;
        this.titleLabelY = 100000;
        this.assignEnergyInfoArea();
    }

    private void renderEnergyInfoArea(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (this.isMouseAboveArea(mouseX, mouseY, x, y, 125, 21, 13, 38)) {
            guiGraphics.renderTooltip(this.font, this.energyInfoArea.getTooltips(), Optional.empty(), mouseX - x, mouseY - y);
        }
    }

    private void assignEnergyInfoArea() {
        this.energyInfoArea = new EnergyDisplayTooltipArea((this.width - this.imageWidth) / 2 + 125, (this.height - this.imageHeight) / 2 + 21, ((GeneratorMenu)this.menu).blockEntity.getEnergyStorage(null), 13, 38);
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.energyInfoArea.render(guiGraphics);
        this.renderFuelProgress(guiGraphics, x, y);
        this.renderInfoIcon(guiGraphics, x, y);
    }

    private void renderInfoIcon(GuiGraphics g, int baseX, int baseY) {
        int ix = baseX + 8;
        int iy = baseY + 8;
        g.blit(INFO_ICON, ix, iy, 0.0f, 0.0f, 8, 8, 8, 8);
    }

    private void renderInfoIconTooltip(GuiGraphics g, int mouseX, int mouseY, int baseX, int baseY) {
        if (this.isMouseAboveArea(mouseX, mouseY, baseX, baseY, 8, 8, 8, 8)) {
            MutableComponent info = Component.translatable((String)"gui.tooltip.generator.info");
            List wrapped = this.font.split((FormattedText)info, 300);
            g.renderTooltip(this.font, wrapped, mouseX, mouseY);
        }
    }

    private void renderFuelProgress(GuiGraphics guiGraphics, int x, int y) {
        int scaledHeight = ((GeneratorMenu)this.menu).getFuelStoredScaled();
        if (scaledHeight > 0) {
            int adjustedY = y + 38 + (11 - scaledHeight);
            guiGraphics.blit(GUI_TEXTURE, x + 81, adjustedY, 176, 14 - scaledHeight, 14, scaledHeight);
        }
    }

    private boolean isMouseAboveArea(int mouseX, int mouseY, int x, int y, int offsetX, int offsetY, int width, int height) {
        return MouseUtil.isMouseOver(mouseX, mouseY, x + offsetX, y + offsetY, width, height);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderEnergyInfoArea(guiGraphics, mouseX, mouseY, x, y);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderInfoIconTooltip(guiGraphics, mouseX, mouseY, x, y);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

