/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.micaxs.smokeleaf.fluid.ModFluids;
import net.micaxs.smokeleaf.item.ModItems;
import net.micaxs.smokeleaf.screen.custom.LiquifierMenu;
import net.micaxs.smokeleaf.screen.renderer.EnergyDisplayTooltipArea;
import net.micaxs.smokeleaf.screen.renderer.FluidTankRenderer;
import net.micaxs.smokeleaf.utils.MouseUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class LiquifierScreen
extends AbstractContainerScreen<LiquifierMenu> {
    public static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"textures/gui/liquifier/liquifier_gui.png");
    private EnergyDisplayTooltipArea energyInfoArea;
    private FluidTankRenderer fluidRenderer;
    private static final ResourceLocation INFO_ICON = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"textures/gui/icons/info.png");
    private static final int ICON_SIZE = 8;
    private static final float TOOLTIP_SCALE = 0.5f;

    public LiquifierScreen(LiquifierMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 100000;
        this.titleLabelY = 100000;
        this.assignEnergyInfoArea();
        this.assignFluidrenderer();
    }

    private void assignFluidrenderer() {
        this.fluidRenderer = new FluidTankRenderer(8000L, true, 16, 64);
    }

    private void renderFluidTooltipArea(GuiGraphics guiGraphics, int pMouseX, int pMouseY, int x, int y, FluidStack stack, int offsetX, int offsetY, FluidTankRenderer renderer) {
        if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, offsetX, offsetY, renderer)) {
            guiGraphics.renderTooltip(this.font, renderer.getTooltip(stack, (TooltipFlag)TooltipFlag.Default.NORMAL), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.energyInfoArea.render(guiGraphics);
        this.fluidRenderer.render(guiGraphics, x + 134, y + 11, ((LiquifierMenu)this.menu).blockEntity.getFluid());
        this.renderProgressArrow(guiGraphics, x, y);
        this.renderInfoIcon(guiGraphics, x, y);
    }

    private void renderInfoIcon(GuiGraphics g, int baseX, int baseY) {
        int ix = baseX + 8;
        int iy = baseY + 8;
        g.blit(INFO_ICON, ix, iy, 0.0f, 0.0f, 8, 8, 8, 8);
    }

    private void renderInfoIconTooltip(GuiGraphics g, int mouseX, int mouseY, int baseX, int baseY) {
        if (this.isMouseAboveAreaEnergy(mouseX, mouseY, baseX, baseY, 8, 8, 8, 8)) {
            MutableComponent info = Component.translatable((String)"gui.tooltip.liquifier.info");
            List wrapped = this.font.split((FormattedText)info, 300);
            g.renderTooltip(this.font, wrapped, mouseX, mouseY);
        }
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((LiquifierMenu)this.menu).isCrafting()) {
            guiGraphics.blit(GUI_TEXTURE, x + 59, y + 35, 0, 166, ((LiquifierMenu)this.menu).getScaledProgress(), 16);
        }
    }

    private void assignEnergyInfoArea() {
        this.energyInfoArea = new EnergyDisplayTooltipArea((this.width - this.imageWidth) / 2 + 156, (this.height - this.imageHeight) / 2 + 11, ((LiquifierMenu)this.menu).blockEntity.getEnergyStorage(null), 8, 64);
    }

    private void renderEnergyInfoArea(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (this.isMouseAboveAreaEnergy(mouseX, mouseY, x, y, 156, 11, 8, 64)) {
            guiGraphics.renderTooltip(this.font, this.energyInfoArea.getTooltips(), Optional.empty(), mouseX - x, mouseY - y);
        }
    }

    private boolean isMouseAboveAreaEnergy(int mouseX, int mouseY, int x, int y, int offsetX, int offsetY, int width, int height) {
        return MouseUtil.isMouseOver(mouseX, mouseY, x + offsetX, y + offsetY, width, height);
    }

    private boolean isMouseAboveArea(int mouseX, int mouseY, int x, int y, int offsetX, int offsetY, FluidTankRenderer renderer) {
        return MouseUtil.isMouseOver(mouseX, mouseY, x + offsetX, y + offsetY, renderer.getWidth(), renderer.getHeight());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (this.fluidRenderer != null && this.isMouseAboveArea((int)mouseX, (int)mouseY, x, y, 134, 11, this.fluidRenderer) && this.minecraft != null && this.minecraft.gameMode != null) {
            if (button == 0) {
                this.minecraft.gameMode.handleInventoryButtonClick(((LiquifierMenu)this.menu).containerId, 0);
                return true;
            }
            if (button == 1) {
                FluidStack stack = ((LiquifierMenu)this.menu).blockEntity.getFluid();
                if (!stack.isEmpty() && stack.getFluid() == ModFluids.SOURCE_HASH_OIL_FLUID.get() && this.minecraft.player.getInventory().getSelected().getItem() == ModItems.EMPTY_TINCTURE.get()) {
                    this.minecraft.player.getInventory().removeItem(this.minecraft.player.getInventory().selected, 1);
                    this.minecraft.player.getInventory().add(new ItemStack((ItemLike)ModItems.HASH_OIL_TINCTURE.get()));
                    return true;
                }
                this.minecraft.gameMode.handleInventoryButtonClick(((LiquifierMenu)this.menu).containerId, 1);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderEnergyInfoArea(guiGraphics, mouseX, mouseY, x, y);
        this.renderFluidTooltipArea(guiGraphics, mouseX, mouseY, x, y, ((LiquifierMenu)this.menu).blockEntity.getFluid(), 134, 11, this.fluidRenderer);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderInfoIconTooltip(guiGraphics, mouseX, mouseY, x, y);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

