/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.screen.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.micaxs.smokeleaf.screen.widget.UvImageButton;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class SmokeleafGuideScreen
extends Screen {
    private static final ResourceLocation TEX = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"textures/gui/smokeleaf_guide.png");
    private static final int TEX_W = 256;
    private static final int TEX_H = 256;
    private static final int IMAGE_WIDTH = 192;
    private static final int IMAGE_HEIGHT = 194;
    private static final int PAGE_U = 0;
    private static final int PAGE_V = 0;
    public static final int PAGE_TEXT_X_OFFSET = 36;
    public static final int PAGE_TEXT_Y_OFFSET = 30;
    protected static final int TEXT_WIDTH = 114;
    protected static final int MAX_LINES = 14;
    public static final int PAGE_INDICATOR_TEXT_Y_OFFSET = 16;
    private static final float TEXT_SCALE = 0.75f;
    private static final int BTN_W = 22;
    private static final int BTN_H = 13;
    private static final float TITLE_SCALE = 1.1f;
    private static final int TITLE_EXTRA_Y = 10;
    private static final int TITLE_BODY_SPACING = 6;
    private BookAccess bookAccess;
    private int currentPage = 0;
    private List<FormattedCharSequence> cachedPageComponents = Collections.emptyList();
    private int cachedPage = -1;
    private UvImageButton forwardButton;
    private UvImageButton backButton;

    public SmokeleafGuideScreen() {
        super(GameNarrator.NO_TITLE);
        ArrayList<Page> pages = new ArrayList<Page>();
        pages.add(new Page((Component)Component.translatable((String)"book.smokeleafindustries.page1.title"), (Component)Component.translatable((String)"book.smokeleafindustries.page1.body")));
        pages.add(new Page((Component)Component.translatable((String)"book.smokeleafindustries.page2.title"), (Component)Component.translatable((String)"book.smokeleafindustries.page2.body")));
        pages.add(new Page((Component)Component.translatable((String)"book.smokeleafindustries.page3.title"), (Component)Component.translatable((String)"book.smokeleafindustries.page3.body")));
        pages.add(new Page((Component)Component.translatable((String)"book.smokeleafindustries.page4.title"), (Component)Component.translatable((String)"book.smokeleafindustries.page4.body")));
        pages.add(new Page((Component)Component.translatable((String)"book.smokeleafindustries.page5.title"), (Component)Component.translatable((String)"book.smokeleafindustries.page5.body")));
        pages.add(new Page((Component)Component.translatable((String)"book.smokeleafindustries.page6.title"), (Component)Component.translatable((String)"book.smokeleafindustries.page6.body")));
        pages.add(new Page((Component)Component.translatable((String)"book.smokeleafindustries.page7.title"), (Component)Component.translatable((String)"book.smokeleafindustries.page7.body")));
        pages.add(new Page((Component)Component.translatable((String)"book.smokeleafindustries.page8.title"), (Component)Component.translatable((String)"book.smokeleafindustries.page8.body")));
        pages.add(new Page((Component)Component.translatable((String)"book.smokeleafindustries.page9.title"), (Component)Component.translatable((String)"book.smokeleafindustries.page9.body")));
        pages.add(new Page((Component)Component.translatable((String)"book.smokeleafindustries.page10.title"), (Component)Component.translatable((String)"book.smokeleafindustries.page10.body")));
        pages.add(new Page((Component)Component.translatable((String)"book.smokeleafindustries.page11.title"), (Component)Component.translatable((String)"book.smokeleafindustries.page11.body")));
        this.bookAccess = new BookAccess(pages);
    }

    public static void open() {
        Minecraft.getInstance().setScreen((Screen)new SmokeleafGuideScreen());
    }

    protected void init() {
        this.createMenuControls();
        this.createPageControlButtons();
    }

    protected void createMenuControls() {
        int top = 2;
        int y = top + 194 + 4;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, b -> this.onClose()).bounds(this.width / 2 - 100, y, 200, 20).build());
    }

    protected void createPageControlButtons() {
        int left = (this.width - 192) / 2;
        int top = 2;
        int btnY = top + 194 - 13 - 28;
        this.forwardButton = (UvImageButton)this.addRenderableWidget((GuiEventListener)new UvImageButton(left + 116, btnY, 22, 13, 0, 193, 23, 193, TEX, 256, 256, b -> this.pageForward()));
        this.backButton = (UvImageButton)this.addRenderableWidget((GuiEventListener)new UvImageButton(left + 43, btnY, 22, 13, 0, 206, 23, 206, TEX, 256, 256, b -> this.pageBack()));
        this.updateButtonVisibility();
    }

    public void setBookAccess(BookAccess access) {
        this.bookAccess = access;
        this.currentPage = Mth.clamp((int)this.currentPage, (int)0, (int)access.getPageCount());
        this.updateButtonVisibility();
        this.cachedPage = -1;
    }

    public boolean setPage(int pageNum) {
        int i = Mth.clamp((int)pageNum, (int)0, (int)(this.bookAccess.getPageCount() - 1));
        if (i != this.currentPage) {
            this.currentPage = i;
            this.updateButtonVisibility();
            this.cachedPage = -1;
            return true;
        }
        return false;
    }

    protected boolean forcePage(int pageNum) {
        return this.setPage(pageNum);
    }

    protected void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.updateButtonVisibility();
    }

    protected void pageForward() {
        if (this.currentPage < this.getNumPages() - 1) {
            ++this.currentPage;
        }
        this.updateButtonVisibility();
    }

    private int getNumPages() {
        return this.bookAccess.getPageCount();
    }

    private void updateButtonVisibility() {
        if (this.forwardButton != null) {
            boolean bl = this.forwardButton.visible = this.currentPage < this.getNumPages() - 1;
        }
        if (this.backButton != null) {
            this.backButton.visible = this.currentPage > 0;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 266: {
                if (this.backButton != null && this.backButton.visible) {
                    this.backButton.onPress();
                }
                return true;
            }
            case 267: {
                if (this.forwardButton != null && this.forwardButton.visible) {
                    this.forwardButton.onPress();
                }
                return true;
            }
        }
        return false;
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        super.render(g, mouseX, mouseY, partialTick);
        int left = (this.width - 192) / 2;
        int top = 2;
        if (this.cachedPage != this.currentPage) {
            FormattedText body = this.bookAccess.getBody(this.currentPage);
            int splitWidth = Mth.floor((float)152.0f);
            this.cachedPageComponents = this.font.split(body, splitWidth);
        }
        this.cachedPage = this.currentPage;
        Component title = this.bookAccess.getTitle(this.currentPage);
        int titleBaseY = top + 30 + 2 + 10;
        int centerX = left + 36 + 57;
        int titleWidth = this.font.width((FormattedText)title);
        g.pose().pushPose();
        g.pose().translate((float)centerX, (float)titleBaseY, 0.0f);
        g.pose().scale(1.1f, 1.1f, 1.0f);
        g.drawString(this.font, title, -titleWidth / 2, 0, 0, false);
        g.pose().popPose();
        int bodyStartY = titleBaseY + Mth.floor((float)9.900001f) + 6;
        int lines = Math.min(14, this.cachedPageComponents.size());
        g.pose().pushPose();
        g.pose().translate((float)(left + 36), (float)bodyStartY, 0.0f);
        g.pose().scale(0.75f, 0.75f, 1.0f);
        for (int l = 0; l < lines; ++l) {
            FormattedCharSequence seq = this.cachedPageComponents.get(l);
            g.drawString(this.font, seq, 0, l * 9, 0, false);
        }
        g.pose().popPose();
        Style style = this.getClickedComponentStyleAt(mouseX, mouseY);
        if (style != null) {
            g.renderComponentHoverEffect(this.font, style, mouseX, mouseY);
        }
    }

    public void renderBackground(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(g);
        int left = (this.width - 192) / 2;
        int top = 2;
        g.blit(TEX, left, top, 0.0f, 0.0f, 192, 194, 256, 256);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Style style;
        if (button == 0 && (style = this.getClickedComponentStyleAt(mouseX, mouseY)) != null && this.handleComponentClicked(style)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean handleComponentClicked(Style style) {
        ClickEvent click = style.getClickEvent();
        if (click == null) {
            return false;
        }
        if (click.getAction() == ClickEvent.Action.CHANGE_PAGE) {
            try {
                int i = Integer.parseInt(click.getValue()) - 1;
                return this.forcePage(i);
            }
            catch (Exception ignored) {
                return false;
            }
        }
        boolean handled = super.handleComponentClicked(style);
        if (handled && click.getAction() == ClickEvent.Action.RUN_COMMAND) {
            this.onClose();
        }
        return handled;
    }

    @Nullable
    public Style getClickedComponentStyleAt(double mouseX, double mouseY) {
        if (this.cachedPageComponents.isEmpty()) {
            return null;
        }
        int left = (this.width - 192) / 2;
        int top = 2;
        int titleBaseY = top + 30 + 2 + 10;
        int bodyStartY = titleBaseY + Mth.floor((float)9.900001f) + 6;
        int xOnScreen = Mth.floor((double)(mouseX - (double)left - 36.0));
        int yOnScreen = Mth.floor((double)(mouseY - (double)bodyStartY));
        if (xOnScreen < 0 || yOnScreen < 0) {
            return null;
        }
        int x = Mth.floor((float)((float)xOnScreen / 0.75f));
        int y = Mth.floor((float)((float)yOnScreen / 0.75f));
        int lines = Math.min(14, this.cachedPageComponents.size());
        int splitWidth = Mth.floor((float)152.0f);
        if (x > splitWidth || y >= 9 * lines) {
            return null;
        }
        int lineIdx = y / 9;
        if (lineIdx < 0 || lineIdx >= this.cachedPageComponents.size()) {
            return null;
        }
        FormattedCharSequence seq = this.cachedPageComponents.get(lineIdx);
        return this.minecraft.font.getSplitter().componentStyleAtWidth(seq, x);
    }

    public record Page(Component title, Component body) {
    }

    public record BookAccess(List<Page> pages) {
        public int getPageCount() {
            return this.pages.size();
        }

        public Component getTitle(int page) {
            return page >= 0 && page < this.getPageCount() ? this.pages.get(page).title() : Component.empty();
        }

        public FormattedText getBody(int page) {
            return page >= 0 && page < this.getPageCount() ? this.pages.get(page).body() : FormattedText.EMPTY;
        }
    }
}

