/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.custom.BaseWeedItem;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;

public class HashOilHelper {
    public static final int MAX_ACTIVE_INGREDIENTS = 2;

    public static boolean setWeedDataFluid(ItemStack itemHandler, FluidStack weedDerivedFluid) {
        BaseWeedItem weedItem = (BaseWeedItem)itemHandler.getItem();
        JsonArray activeIngredients = (JsonArray)weedDerivedFluid.get(ModDataComponentTypes.ACTIVE_INGREDIENTS);
        if (activeIngredients == null) {
            activeIngredients = new JsonArray();
        }
        if (activeIngredients.size() >= 2) {
            return true;
        }
        if (!activeIngredients.contains(JsonParser.parseString((String)weedItem.getDescriptionId()))) {
            activeIngredients.add(weedItem.getDescriptionId());
        }
        weedDerivedFluid.set(ModDataComponentTypes.ACTIVE_INGREDIENTS, (Object)activeIngredients);
        return false;
    }

    public static void transferWeedFluidDataToBucket(ItemStack hashOilBucket, FluidStack hashOilFluid) {
        JsonArray active = (JsonArray)hashOilFluid.get(ModDataComponentTypes.ACTIVE_INGREDIENTS);
        if (active != null && !active.isEmpty()) {
            hashOilBucket.set(ModDataComponentTypes.ACTIVE_INGREDIENTS, (Object)active.deepCopy());
        } else {
            hashOilBucket.remove(ModDataComponentTypes.ACTIVE_INGREDIENTS);
        }
    }

    public static Component getHashOilName(List<BaseWeedItem> activeWeedIngredients, String translatableBaseKey, String translatableBlendKey) {
        if (activeWeedIngredients.size() == 1) {
            BaseWeedItem activeIngredient = activeWeedIngredients.getFirst();
            Component weedNameComponent = activeIngredient.getName(activeIngredient.getDefaultInstance());
            String weedName = weedNameComponent.getString().replace(" Weed", "").replace(" weed", "");
            return Component.literal((String)weedName).append(" ").append((Component)Component.translatable((String)translatableBaseKey));
        }
        if (activeWeedIngredients.size() == 2) {
            return Component.translatable((String)translatableBlendKey, (Object[])new Object[]{activeWeedIngredients.get(0).getWeedNameParts()[0], activeWeedIngredients.get(1).getWeedNameParts()[1]});
        }
        return Component.literal((String)"nono");
    }

    public static List<BaseWeedItem> getActiveWeedIngredient(FluidStack fluidStack) {
        JsonArray activeIngredients = (JsonArray)fluidStack.get(ModDataComponentTypes.ACTIVE_INGREDIENTS);
        if (activeIngredients == null || activeIngredients.size() == 0) {
            return List.of();
        }
        if (activeIngredients.size() >= 3) {
            return List.of();
        }
        ArrayList<BaseWeedItem> result = new ArrayList<BaseWeedItem>();
        for (JsonElement activeIngredientElement : activeIngredients.asList()) {
            String[] parts = activeIngredientElement.getAsString().split("\\.");
            String activeIngredientName = parts[parts.length - 1];
            DeferredHolder activeIngredient = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)activeIngredientName));
            Object object = activeIngredient.get();
            if (!(object instanceof BaseWeedItem)) continue;
            BaseWeedItem activeIngredientItem = (BaseWeedItem)((Object)object);
            activeIngredientItem.setVariableDuration(false);
            activeIngredientItem.setDurationMultiplier(2.0f);
            result.add(activeIngredientItem);
        }
        return result;
    }
}

