/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.client.models.items.SidedCurioModel;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class AmphibianBootItem
extends RelicItem
implements IRenderableCurio {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("swimming").stat(StatData.builder("speed").initialValue(0.005, 0.01).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value * 100.0 * 4.0, 1)).build()).stat(StatData.builder("duration").initialValue(15.0, 35.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value / 5.0, 1)).build()).build()).ability(AbilityData.builder("slipping").stat(StatData.builder("speed").initialValue(0.005, 0.01).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value * 100.0 * 4.0, 1)).build()).stat(StatData.builder("duration").initialValue(15.0, 25.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value / 5.0, 1)).build()).build()).ability(AbilityData.builder("gills").stat(StatData.builder("chance").initialValue(0.01, 0.1).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.35).formatValue(value -> MathUtils.round(value * 100.0, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootEntries.AQUATIC).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        int charge = (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0);
        boolean isSwimming = false;
        boolean isSlipping = false;
        if (player.isSwimming()) {
            isSwimming = true;
            if (player.tickCount % 20 == 0) {
                this.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
            if ((double)charge < this.getStatValue(stack, "swimming", "duration")) {
                stack.set(DataComponentRegistry.CHARGE, (Object)(charge + 1));
            }
        }
        EntityUtils.removeAttribute((LivingEntity)player, stack, (Holder<Attribute>)NeoForgeMod.SWIM_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        if (charge > 0) {
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Holder<Attribute>)NeoForgeMod.SWIM_SPEED, (float)((double)charge * this.getStatValue(stack, "swimming", "speed")), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
        if (player.isSprinting() && player.level().isRainingAt(player.blockPosition()) && !player.isShiftKeyDown() && !player.isInWater() && !player.isInLava()) {
            isSlipping = true;
            if (player.tickCount % 20 == 0) {
                this.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
            if ((double)charge < this.getStatValue(stack, "slipping", "duration") && player.tickCount % 4 == 0) {
                stack.set(DataComponentRegistry.CHARGE, (Object)(charge + 1));
            }
        }
        if (!isSwimming && !isSlipping && charge > 0) {
            stack.set(DataComponentRegistry.CHARGE, (Object)(--charge));
        }
        EntityUtils.removeAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        if (charge > 0) {
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, (float)((double)charge * this.getStatValue(stack, "slipping", "speed")), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.STEP_HEIGHT, 0.6f, AttributeModifier.Operation.ADD_VALUE);
        } else {
            EntityUtils.removeAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.STEP_HEIGHT, AttributeModifier.Operation.ADD_VALUE);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        EntityUtils.removeAttribute(slotContext.entity(), stack, (Holder<Attribute>)NeoForgeMod.SWIM_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.removeAttribute(slotContext.entity(), stack, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.removeAttribute(slotContext.entity(), stack, (Holder<Attribute>)Attributes.STEP_HEIGHT, AttributeModifier.Operation.ADD_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CurioModel getModel(ItemStack stack) {
        return new SidedCurioModel(stack.getItem());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        if (!(model instanceof SidedCurioModel)) {
            return;
        }
        SidedCurioModel sidedModel = (SidedCurioModel)model;
        sidedModel.setSlot(slotContext.index());
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        sidedModel.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        sidedModel.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{sidedModel});
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        matrixStack.translate(0.0f, 0.0f, -0.025f);
        sidedModel.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition rightLeg = mesh.getRoot().addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 9).addBox(-2.9f, 5.5f, -2.5f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 1).addBox(-2.9f, 5.5f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.175f)).texOffs(18, 9).addBox(-2.9f, 9.5f, -4.5f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.5f));
        rightLeg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, -1).addBox(1.5f, 6.5f, 4.4f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        rightLeg.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, -1).mirror().addBox(-1.325f, 6.5f, 4.2f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition leftLeg = mesh.getRoot().addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 9).addBox(-2.9f, 5.5f, -2.5f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 1).addBox(-2.9f, 5.5f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.175f)).texOffs(18, 9).addBox(-2.9f, 9.5f, -4.5f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.5f));
        leftLeg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, -1).addBox(1.5f, 6.5f, 4.4f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        leftLeg.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, -1).mirror().addBox(-1.325f, 6.5f, 4.2f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_leg", "left_leg"});
    }

    @EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onLivingBreath(LivingBreatheEvent event) {
            LivingEntity entity = event.getEntity();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.AMPHIBIAN_BOOT.get());
            Item item = stack.getItem();
            if (!(item instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)item;
            double chance = relic.getStatValue(stack, "gills", "chance");
            if (event.getConsumeAirAmount() > 0 && entity.getRandom().nextDouble() <= chance) {
                event.setConsumeAirAmount(0);
            }
        }
    }
}

