/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.util;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec2;
import net.tejty.gamediscs.games.gamediscs.BlocktrisGame;
import net.tejty.gamediscs.games.util.Grid;

public class BlocktrisPiece {
    private final List<List<Vec2>> variants;
    private final BlocktrisGame game;
    private int x;
    private int y;
    private int rotation;
    private int color;
    private final Grid grid;
    private List<Vec2> altPositions = List.of(new Vec2(0.0f, 1.0f), new Vec2(-1.0f, 1.0f), new Vec2(1.0f, 1.0f), new Vec2(-1.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, -1.0f), new Vec2(-1.0f, -1.0f), new Vec2(1.0f, -1.0f));
    public static final Supplier<List<List<Vec2>>> TRIANGLE = () -> List.of(List.of(new Vec2(0.0f, 0.0f), new Vec2(0.0f, -1.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, 1.0f)), List.of(new Vec2(0.0f, 0.0f), new Vec2(-1.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, 1.0f)), List.of(new Vec2(0.0f, 0.0f), new Vec2(0.0f, -1.0f), new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 1.0f)), List.of(new Vec2(0.0f, 0.0f), new Vec2(0.0f, -1.0f), new Vec2(1.0f, 0.0f), new Vec2(-1.0f, 0.0f)));
    public static final Supplier<List<List<Vec2>>> J = () -> List.of(List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(-1.0f, 1.0f)), List.of(new Vec2(-1.0f, -1.0f), new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f)), List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, -1.0f)), List.of(new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(1.0f, 1.0f)));
    public static final Supplier<List<List<Vec2>>> LINE = () -> List.of(List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(0.0f, 2.0f)), List.of(new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(2.0f, 0.0f)));
    public static final Supplier<List<List<Vec2>>> Z = () -> List.of(List.of(new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(-1.0f, 1.0f), new Vec2(0.0f, -1.0f)), List.of(new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f)));
    public static final Supplier<List<List<Vec2>>> SQUARE = () -> List.of(List.of(new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f)));
    public static final Supplier<List<List<Vec2>>> L = () -> List.of(List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f)), List.of(new Vec2(-1.0f, 1.0f), new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f)), List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(-1.0f, -1.0f)), List.of(new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(1.0f, -1.0f)));
    public static final Supplier<List<List<Vec2>>> S = () -> List.of(List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(1.0f, 1.0f)), List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, -1.0f), new Vec2(-1.0f, 0.0f)));
    public static final List<Supplier<List<List<Vec2>>>> PIECES = List.of(TRIANGLE, J, LINE, Z, SQUARE, L, S);

    public BlocktrisPiece(List<List<Vec2>> variants, int x, int y, int color, BlocktrisGame game) {
        this.variants = variants;
        this.x = x;
        this.y = y;
        this.color = color;
        this.grid = game.grid;
        this.game = game;
    }

    public List<Vec2> current() {
        return this.variants.get(this.rotation);
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean isTouching() {
        for (Vec2 part : this.current()) {
            if (part.x + (float)this.x >= (float)this.grid.width() || part.x + (float)this.x < 0.0f || part.y + (float)this.y >= (float)this.grid.height() || part.y + (float)this.y < 0.0f) {
                return true;
            }
            if (this.grid.get((int)part.x + this.x, (int)part.y + this.y) == 0) continue;
            return true;
        }
        return false;
    }

    public void rotate() {
        block3: {
            ++this.rotation;
            if (this.rotation >= this.variants.size()) {
                this.rotation = 0;
            }
            if (!this.isTouching()) break block3;
            int oldX = this.x;
            int oldY = this.y;
            int i = 0;
            do {
                this.x = oldX;
                this.y = oldY;
                this.x += (int)this.altPositions.get((int)i).x;
                this.y += (int)this.altPositions.get((int)i).y;
                if (!this.isTouching()) break block3;
            } while (++i < this.altPositions.size());
            this.x = oldX;
            this.y = oldY;
            --this.rotation;
            if (this.rotation < 0) {
                this.rotation = this.variants.size() - 1;
            }
        }
    }

    public boolean move(int x, int y) {
        boolean flag = false;
        this.x += x;
        if (this.isTouching()) {
            this.x -= x;
            flag = true;
        }
        this.y += y;
        if (this.isTouching()) {
            this.y -= y;
            flag = true;
        }
        return flag;
    }

    public void hardDrop() {
        while (!this.move(0, 1)) {
        }
    }

    public void place() {
        for (Vec2 part : this.current()) {
            this.grid.set(this.x + (int)part.x, this.y + (int)part.y, this.color + 1);
        }
    }

    public void tick() {
        ++this.y;
    }

    public void render(GuiGraphics graphics, int posX, int posY) {
        this.grid.getImages().setImage(this.color + 1);
        for (Vec2 part : this.current()) {
            this.grid.getImages().render(graphics, posX + (this.x + (int)part.x) * this.grid.tileSize(), posY + (this.y + (int)part.y) * this.grid.tileSize());
        }
    }

    public void renderCentered(GuiGraphics graphics, int posX, int posY) {
        this.grid.getImages().setImage(this.color + 1);
        Vec2 smallest = null;
        Vec2 biggest = null;
        for (int i = 0; i < this.current().size(); ++i) {
            Vec2 part = this.current().get(i);
            if (smallest == null) {
                smallest = part;
            }
            if (biggest == null) {
                biggest = part;
            }
            smallest = new Vec2(Math.min(smallest.x, part.x), Math.min(smallest.y, part.y));
            biggest = new Vec2(Math.max(biggest.x, part.x), Math.max(biggest.y, part.y));
        }
        Vec2 addition = smallest.add(biggest.negated()).scale(0.5f).add(biggest).negated();
        for (Vec2 part : this.current()) {
            this.grid.getImages().render(graphics, posX + (int)(((float)this.x + part.x + addition.x) * (float)this.grid.tileSize()), posY + (int)(((float)(this.y + (int)part.y) + addition.y) * (float)this.grid.tileSize()));
        }
    }

    public void setRotation(int direction) {
        this.rotation = direction;
        if (this.rotation >= this.variants.size()) {
            this.rotation = this.variants.size() - 1;
        }
        if (this.rotation < 0) {
            this.rotation = 0;
        }
    }
}

