/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.network.PacketDistributor;
import net.tejty.gamediscs.games.audio.SoundPlayer;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.controls.Controls;
import net.tejty.gamediscs.games.graphics.ParticleColor;
import net.tejty.gamediscs.games.graphics.Renderer;
import net.tejty.gamediscs.games.util.ConfettiParticle;
import net.tejty.gamediscs.games.util.ExplosionParticle;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Particle;
import net.tejty.gamediscs.games.util.ParticleLevel;
import net.tejty.gamediscs.item.ItemRegistry;
import net.tejty.gamediscs.item.custom.GamingConsoleItem;
import net.tejty.gamediscs.networking.packet.SetBestScorePacket;
import net.tejty.gamediscs.sounds.SoundRegistry;

public class Game {
    public GameStage stage = GameStage.START;
    public Controls controls = new Controls(this);
    public SoundPlayer soundPlayer = new SoundPlayer();
    public static final int WIDTH = 140;
    public static final int HEIGHT = 100;
    public final Random random = new Random();
    public int ticks = 0;
    public int score = 0;
    public int lives = this.maxLives();
    private List<Particle> particles = new ArrayList<Particle>();

    public int maxLives() {
        return 1;
    }

    public void prepare() {
        this.score = 0;
        this.lives = this.maxLives();
        this.respawn();
    }

    public void start() {
        this.stage = GameStage.PLAYING;
        this.ticks = 1;
    }

    public void die() {
        if (this.getConsole().getItem() instanceof GamingConsoleItem) {
            String gameName = this.getClass().getName().substring(this.getClass().getPackageName().length() + 1);
            if (GamingConsoleItem.getBestScore(this.getConsole(), gameName, (Player)Minecraft.getInstance().player) < this.score) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SetBestScorePacket(gameName, this.score), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.soundPlayer.playNewBest();
                this.spawnConfetti();
            } else {
                this.soundPlayer.playGameOver();
            }
        }
        this.stage = GameStage.DIED;
        this.ticks = 1;
    }

    public void lostLife() {
        --this.lives;
        this.soundPlayer.play((SoundEvent)SoundRegistry.EXPLOSION.get());
        this.respawn();
        if (this.lives <= 0) {
            this.die();
        }
    }

    public void respawn() {
        this.stage = GameStage.START;
        this.ticks = 1;
        this.particles.clear();
    }

    public void win() {
        this.soundPlayer.playNewBest();
        this.spawnConfetti();
        if (this.getConsole().getItem() instanceof GamingConsoleItem) {
            String gameName = this.getClass().getName().substring(this.getClass().getPackageName().length() + 1);
            if (GamingConsoleItem.getBestScore(this.getConsole(), gameName, (Player)Minecraft.getInstance().player) < this.score) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SetBestScorePacket(gameName, this.score), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        this.stage = GameStage.WON;
        this.ticks = 1;
    }

    private ItemStack getConsole() {
        LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        ItemStack item = player.getMainHandItem();
        if (item.getItem() instanceof GamingConsoleItem) {
            return item;
        }
        item = player.getOffhandItem();
        if (item.getItem() instanceof GamingConsoleItem) {
            return item;
        }
        return new ItemStack((ItemLike)ItemRegistry.GAMING_CONSOLE.get());
    }

    public void tick() {
        if (this.stage == GameStage.PLAYING && this.ticks % this.gameTickDuration() == 0) {
            this.gameTick();
        }
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = this.particles.get(i);
            particle.tick();
            if (!particle.isDead()) continue;
            this.particles.remove(i);
            --i;
        }
        ++this.ticks;
    }

    public void gameTick() {
    }

    public void render(GuiGraphics graphics, int posX, int posY) {
        if (this.getBackground() != null) {
            graphics.blit(this.getBackground(), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
        }
        this.renderOverlay(graphics, posX, posY);
    }

    public void renderOverlay(GuiGraphics graphics, int posX, int posY) {
        Font font = Minecraft.getInstance().font;
        if (this.stage != GameStage.PLAYING) {
            if (this.showPressAnyKey()) {
                MutableComponent mutableComponent = Component.translatable((String)"gui.gamingconsole.press_any_key");
                int n = posX + (140 - font.width(Component.translatable((String)"gui.gamingconsole.press_any_key").getVisualOrderText())) / 2 + 1;
                Objects.requireNonNull(font);
                graphics.drawString(font, (Component)mutableComponent, n, posY + 100 - 9 - 1 - (this.ticks % 40 <= 20 ? 0 : 1), 0x373737, false);
                MutableComponent mutableComponent2 = Component.translatable((String)"gui.gamingconsole.press_any_key");
                int n2 = posX + (140 - font.width(Component.translatable((String)"gui.gamingconsole.press_any_key").getVisualOrderText())) / 2;
                Objects.requireNonNull(font);
                graphics.drawString(font, (Component)mutableComponent2, n2, posY + 100 - 9 - 2 - (this.ticks % 40 <= 20 ? 0 : 1), 0xFFFFFF, false);
            }
            if (this.stage == GameStage.DIED || this.stage == GameStage.WON) {
                graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/gui/score_board.png"), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
                MutableComponent component = this.stage == GameStage.DIED ? Component.translatable((String)"gui.gamingconsole.died").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_RED}) : Component.translatable((String)"gui.gamingconsole.won").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_GREEN});
                graphics.drawString(font, (Component)component, posX + (140 - font.width(component.getVisualOrderText())) / 2, posY + 29, Objects.requireNonNull(component.getStyle().getColor()).getValue(), false);
                graphics.drawString(font, (Component)component, posX + (140 - font.width(component.getVisualOrderText())) / 2, posY + 31, component.getStyle().getColor().getValue(), false);
                graphics.drawString(font, (Component)component, posX + (140 - font.width(component.getVisualOrderText())) / 2 + 1, posY + 30, component.getStyle().getColor().getValue(), false);
                graphics.drawString(font, (Component)component, posX + (140 - font.width(component.getVisualOrderText())) / 2 - 1, posY + 30, component.getStyle().getColor().getValue(), false);
                component = this.stage == GameStage.DIED ? Component.translatable((String)"gui.gamingconsole.died").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}) : Component.translatable((String)"gui.gamingconsole.won").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN});
                graphics.drawString(font, (Component)component, posX + (140 - font.width(component.getVisualOrderText())) / 2, posY + 30, Objects.requireNonNull(component.getStyle().getColor()).getValue(), false);
                component = Component.translatable((String)"gui.gamingconsole.score").append(": ").append(String.valueOf(this.score)).withStyle(ChatFormatting.YELLOW);
                int n = posX + (140 - font.width(component.getVisualOrderText())) / 2;
                Objects.requireNonNull(font);
                graphics.drawString(font, (Component)component, n, posY + 35 + 9, Objects.requireNonNull(component.getStyle().getColor()).getValue(), false);
                int bestScore = GamingConsoleItem.getBestScore(this.getConsole(), this.getClass().getName().substring(this.getClass().getPackageName().length() + 1), (Player)Minecraft.getInstance().player);
                component = Component.translatable((String)(this.score >= bestScore ? "gui.gamingconsole.new_best_score" : "gui.gamingconsole.best_score")).append(": ").append(String.valueOf(bestScore)).withStyle(this.score >= bestScore ? ChatFormatting.GREEN : ChatFormatting.YELLOW);
                int n3 = posX + (140 - font.width(component.getVisualOrderText())) / 2;
                Objects.requireNonNull(font);
                graphics.drawString(font, (Component)component, n3, posY + 50 + 9, Objects.requireNonNull(component.getStyle().getColor()).getValue(), false);
            }
        } else {
            if (this.showScoreBox() && this.showScore()) {
                graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/gui/score_box.png"), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
            }
            if (this.showScore()) {
                graphics.drawString(font, (Component)(this.scoreText() ? Component.translatable((String)"gui.gamingconsole.score").append(": ") : Component.empty()).append(String.valueOf(this.score)), posX + 2, posY + 2, 0x373737, false);
                graphics.drawString(font, (Component)(this.scoreText() ? Component.translatable((String)"gui.gamingconsole.score").append(": ") : Component.empty()).append(String.valueOf(this.score)), posX + 1, posY + 1, this.scoreColor(), false);
            }
        }
        for (Particle particle : this.particles) {
            if (!particle.isForOverlay()) continue;
            particle.render(graphics, posX, posY, this.stage);
        }
    }

    public void renderParticles(GuiGraphics graphics, int posX, int posY) {
        for (Particle particle : this.particles) {
            particle.render(graphics, posX, posY, this.stage);
        }
    }

    public void buttonDown(Button button) {
        this.soundPlayer.playClick(true);
        if ((this.stage == GameStage.START || this.stage == GameStage.RETRY) && this.ticks > 8) {
            this.start();
        } else if ((this.stage == GameStage.WON || this.stage == GameStage.DIED) && this.ticks > 8) {
            this.prepare();
        }
    }

    public Particle addParticle(Particle particle) {
        this.particles.add(particle);
        return particle;
    }

    public void spawnParticleExplosion(Supplier<Renderer> renderer, Vec2 pos, int count, int speed, int lifetime, ParticleLevel level) {
        for (int i = 0; i < count; ++i) {
            Particle particle = new Particle(pos, renderer.get(), this.random.nextInt(lifetime / 2, lifetime), level);
            particle.setVelocity(new Vec2(this.random.nextFloat(-speed, speed), this.random.nextFloat(-speed, speed)));
            this.particles.add(particle);
        }
    }

    public void spawnParticleExplosion(Vec2 pos, int count, int speed, int lifetime, ParticleLevel level) {
        this.soundPlayer.play((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.5f, 0.1f);
        for (int i = 0; i < count; ++i) {
            ExplosionParticle particle = new ExplosionParticle(pos, this.random.nextInt(lifetime / 2, lifetime), level);
            particle.setVelocity(new Vec2(this.random.nextFloat(-speed, speed), this.random.nextFloat(-speed, speed)));
            this.particles.add(particle);
        }
    }

    public void spawnConfetti() {
        ConfettiParticle particle;
        int i;
        for (i = 0; i < 30; ++i) {
            particle = new ConfettiParticle(new Vec2(0.0f, 100.0f), ParticleColor.random(this.random), this.random.nextInt(50, 70), ParticleLevel.OVERLAY);
            particle.setVelocity(new Vec2(this.random.nextFloat(1.0f, 10.0f), this.random.nextFloat(-25.0f, -10.0f)));
            this.particles.add(particle);
        }
        for (i = 0; i < 30; ++i) {
            particle = new ConfettiParticle(new Vec2(140.0f, 100.0f), ParticleColor.random(this.random), this.random.nextInt(50, 70), ParticleLevel.OVERLAY);
            particle.setVelocity(new Vec2(this.random.nextFloat(-10.0f, -1.0f), this.random.nextFloat(-25.0f, -10.0f)));
            this.particles.add(particle);
        }
    }

    public void buttonUp(Button button) {
        this.soundPlayer.playClick(false);
    }

    public int gameTickDuration() {
        return 1;
    }

    public ResourceLocation getBackground() {
        return null;
    }

    public boolean showScoreBox() {
        return true;
    }

    public boolean showScore() {
        return true;
    }

    public boolean showPressAnyKey() {
        return true;
    }

    public int scoreColor() {
        return 0xFFFFFF;
    }

    public boolean scoreText() {
        return true;
    }

    public Component getName() {
        return Component.empty();
    }

    public ResourceLocation getIcon() {
        return null;
    }

    public ChatFormatting getColor() {
        return ChatFormatting.YELLOW;
    }

    public boolean isEmpty() {
        return this.getClass().equals(Game.class);
    }
}

