/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MekanismWeaponryConfig {
    public static final MekanismWeaponryConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    private final ModConfigSpec.DoubleValue plasmaRifleDamage;
    private final ModConfigSpec.IntValue plasmaRifleCooldown;
    private final ModConfigSpec.IntValue plasmaRifleEnergyUsage;
    private final ModConfigSpec.IntValue plasmaRifleReloadTime;
    private final ModConfigSpec.IntValue plasmaRifleHeatPerShot;
    private final ModConfigSpec.IntValue plasmaRifleEnergyCapacity;
    private final ModConfigSpec.IntValue plasmaRifleEnergyTransfer;
    private final ModConfigSpec.DoubleValue railgunDamage;
    private final ModConfigSpec.IntValue railgunCooldown;
    private final ModConfigSpec.IntValue railgunEnergyUsage;
    private final ModConfigSpec.IntValue railgunReloadTime;
    private final ModConfigSpec.IntValue railgunMaxAmmo;
    private final ModConfigSpec.IntValue railgunEnergyCapacity;
    private final ModConfigSpec.IntValue railgunEnergyTransfer;
    private final ModConfigSpec.DoubleValue railgunSecondModeScale;
    private final ModConfigSpec.DoubleValue teslaMinigunDamage;
    private final ModConfigSpec.IntValue teslaMinigunCooldown;
    private final ModConfigSpec.IntValue teslaMinigunEnergyUsage;
    private final ModConfigSpec.IntValue teslaMinigunReloadTime;
    private final ModConfigSpec.IntValue teslaMinigunHeatPerShot;
    private final ModConfigSpec.IntValue teslaMinigunEnergyCapacity;
    private final ModConfigSpec.IntValue teslaMinigunEnergyTransfer;
    private final ModConfigSpec.DoubleValue gauntletDamage;
    private final ModConfigSpec.IntValue gauntletEnergyUsage;
    private final ModConfigSpec.IntValue gauntletEnergyCapacity;
    private final ModConfigSpec.IntValue gauntletEnergyTransfer;

    public MekanismWeaponryConfig(ModConfigSpec.Builder builder) {
        builder.push("Mekanism Weaponry Config");
        this.plasmaRifleDamage = builder.comment("Damage dealt by plasma rifle projectile").defineInRange("plasmaRifleDamage", 8.0, 0.0, 3.4028234663852886E38);
        this.plasmaRifleCooldown = builder.comment("Cooldown in ticks between when gun can be shot").defineInRange("plasmaRifleCooldown", 6, 0, Integer.MAX_VALUE);
        this.plasmaRifleEnergyUsage = builder.comment("How much FE should be drained from the guns battery every shot").defineInRange("plasmaRifleEnergyUsage", 175, 0, Integer.MAX_VALUE);
        this.plasmaRifleReloadTime = builder.comment("How many ticks it should take to reload the weapon").defineInRange("plasmaRifleReloadTime", 45, 0, Integer.MAX_VALUE);
        this.plasmaRifleHeatPerShot = builder.comment("How much heat should accumulate every shot").defineInRange("plasmaRifleHeatPerShot", 20, 0, Integer.MAX_VALUE);
        this.plasmaRifleEnergyCapacity = builder.comment("How much energy the gun can store").defineInRange("plasmaRifleEnergyCapacity", 50000, 0, Integer.MAX_VALUE);
        this.plasmaRifleEnergyTransfer = builder.comment("How fast the gun battery can charge/discharge").defineInRange("plasmaRifleEnergyTransfer", 1000, 0, Integer.MAX_VALUE);
        this.railgunDamage = builder.comment("Damage dealt by railgun rod").defineInRange("railgunDamage", 16.0, 0.0, 3.4028234663852886E38);
        this.railgunCooldown = builder.comment("Cooldown in ticks between when gun can be shot").defineInRange("railgunCooldown", 20, 0, Integer.MAX_VALUE);
        this.railgunEnergyUsage = builder.comment("How much FE should be drained from the guns battery every shot").defineInRange("railgunEnergyUsage", 1000, 0, Integer.MAX_VALUE);
        this.railgunReloadTime = builder.comment("How many ticks it should take to reload the weapon").defineInRange("railgunReloadTime", 55, 0, Integer.MAX_VALUE);
        this.railgunMaxAmmo = builder.comment("Max ammo the gun can hold").defineInRange("railgunMaxAmmo", 5, 1, Integer.MAX_VALUE);
        this.railgunEnergyCapacity = builder.comment("How much energy the gun can store").defineInRange("railgunEnergyCapacity", 75000, 0, Integer.MAX_VALUE);
        this.railgunEnergyTransfer = builder.comment("How fast the gun battery can charge/discharge").defineInRange("railgunEnergyTransfer", 10000, 0, Integer.MAX_VALUE);
        this.railgunSecondModeScale = builder.comment("Stats scaling when railgun is in second mode").defineInRange("railgunSecondModeScale", 2.0, 0.0, 3.4028234663852886E38);
        this.teslaMinigunDamage = builder.comment("Damage dealt by tesla minigun").defineInRange("teslaMinigunDamage", 2.5, 0.0, 3.4028234663852886E38);
        this.teslaMinigunCooldown = builder.comment("Cooldown in ticks between when gun can be shot").defineInRange("teslaMinigunCooldown", 4, 0, Integer.MAX_VALUE);
        this.teslaMinigunEnergyUsage = builder.comment("How much FE should be drained from the guns battery every shot").defineInRange("teslaMinigunEnergyUsage", 500, 0, Integer.MAX_VALUE);
        this.teslaMinigunReloadTime = builder.comment("How many ticks it should take to reload the weapon").defineInRange("teslaMinigunReloadTime", 100, 0, Integer.MAX_VALUE);
        this.teslaMinigunHeatPerShot = builder.comment("How much heat should accumulate every shot").defineInRange("teslaMinigunHeatPerShot", 5, 0, Integer.MAX_VALUE);
        this.teslaMinigunEnergyCapacity = builder.comment("How much energy the gun can store").defineInRange("teslaMinigunEnergyCapacity", 75000, 0, Integer.MAX_VALUE);
        this.teslaMinigunEnergyTransfer = builder.comment("How fast the gun battery can charge/discharge").defineInRange("teslaMinigunEnergyTransfer", 10000, 0, Integer.MAX_VALUE);
        this.gauntletDamage = builder.comment("Damage dealt by gauntlet").defineInRange("gauntletDamage", 5.0, 0.0, 3.4028234663852886E38);
        this.gauntletEnergyUsage = builder.comment("How much FE should be drained from the battery every shot").defineInRange("gauntletEnergyUsage", 1000, 0, Integer.MAX_VALUE);
        this.gauntletEnergyCapacity = builder.comment("How much energy the gauntlet battery can store").defineInRange("gauntletEnergyCapacity", 15000, 0, Integer.MAX_VALUE);
        this.gauntletEnergyTransfer = builder.comment("How fast the gauntlet battery can charge/discharge").defineInRange("gauntletEnergyTransfer", 1000, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    public double getPlasmaRifleDamage() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Double)this.plasmaRifleDamage.getDefault();
        }
        return (Double)this.plasmaRifleDamage.get();
    }

    public int getPlasmaRifleCooldown() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.plasmaRifleCooldown.getDefault();
        }
        return (Integer)this.plasmaRifleCooldown.get();
    }

    public int getPlasmaRifleEnergyUsage() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.plasmaRifleEnergyUsage.getDefault();
        }
        return (Integer)this.plasmaRifleEnergyUsage.get();
    }

    public int getPlasmaRifleReloadTime() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.plasmaRifleReloadTime.getDefault();
        }
        return (Integer)this.plasmaRifleReloadTime.get();
    }

    public int getPlasmaRifleHeatPerShot() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.plasmaRifleHeatPerShot.getDefault();
        }
        return (Integer)this.plasmaRifleHeatPerShot.get();
    }

    public int getPlasmaRifleEnergyCapacity() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.plasmaRifleEnergyCapacity.getDefault();
        }
        return (Integer)this.plasmaRifleEnergyCapacity.get();
    }

    public int getPlasmaRifleEnergyTransfer() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.plasmaRifleEnergyTransfer.getDefault();
        }
        return (Integer)this.plasmaRifleEnergyTransfer.get();
    }

    public double getRailgunDamage() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Double)this.railgunDamage.getDefault();
        }
        return (Double)this.railgunDamage.get();
    }

    public int getRailgunCooldown() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.railgunCooldown.getDefault();
        }
        return (Integer)this.railgunCooldown.get();
    }

    public int getRailgunEnergyUsage() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.railgunEnergyUsage.getDefault();
        }
        return (Integer)this.railgunEnergyUsage.get();
    }

    public int getRailgunReloadTime() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.railgunReloadTime.getDefault();
        }
        return (Integer)this.railgunReloadTime.get();
    }

    public int getRailgunMaxAmmo() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.railgunMaxAmmo.getDefault();
        }
        return (Integer)this.railgunMaxAmmo.get();
    }

    public int getRailgunEnergyCapacity() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.railgunEnergyCapacity.getDefault();
        }
        return (Integer)this.railgunEnergyCapacity.get();
    }

    public int getRailgunEnergyTransfer() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.railgunEnergyTransfer.getDefault();
        }
        return (Integer)this.railgunEnergyTransfer.get();
    }

    public double getRailgunSecondModeScale() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Double)this.railgunSecondModeScale.getDefault();
        }
        return (Double)this.railgunSecondModeScale.get();
    }

    public double getTeslaMinigunDamage() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Double)this.teslaMinigunDamage.getDefault();
        }
        return (Double)this.teslaMinigunDamage.get();
    }

    public int getTeslaMinigunCooldown() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.teslaMinigunCooldown.getDefault();
        }
        return (Integer)this.teslaMinigunCooldown.get();
    }

    public int getTeslaMinigunEnergyUsage() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.teslaMinigunEnergyUsage.getDefault();
        }
        return (Integer)this.teslaMinigunEnergyUsage.get();
    }

    public int getTeslaMinigunReloadTime() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.teslaMinigunReloadTime.getDefault();
        }
        return (Integer)this.teslaMinigunReloadTime.get();
    }

    public int getTeslaMinigunHeatPerShot() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.teslaMinigunHeatPerShot.getDefault();
        }
        return (Integer)this.teslaMinigunHeatPerShot.get();
    }

    public int getTeslaMinigunEnergyCapacity() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.teslaMinigunEnergyCapacity.getDefault();
        }
        return (Integer)this.teslaMinigunEnergyCapacity.get();
    }

    public int getTeslaMinigunEnergyTransfer() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.teslaMinigunEnergyTransfer.getDefault();
        }
        return (Integer)this.teslaMinigunEnergyTransfer.get();
    }

    public double getGauntletDamage() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Double)this.gauntletDamage.getDefault();
        }
        return (Double)this.gauntletDamage.get();
    }

    public int getGauntletEnergyUsage() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.gauntletEnergyUsage.getDefault();
        }
        return (Integer)this.gauntletEnergyUsage.get();
    }

    public int getGauntletEnergyCapacity() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.gauntletEnergyCapacity.getDefault();
        }
        return (Integer)this.gauntletEnergyCapacity.get();
    }

    public int getGauntletEnergyTransfer() {
        if (!CONFIG_SPEC.isLoaded()) {
            return (Integer)this.gauntletEnergyTransfer.getDefault();
        }
        return (Integer)this.gauntletEnergyTransfer.get();
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(MekanismWeaponryConfig::new);
        CONFIG = (MekanismWeaponryConfig)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }
}

