/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.client.renderer;

import com.github.x3r.mekanism_weaponry.common.entity.PlasmaEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtil;

public class PlasmaRenderer
extends GeoEntityRenderer<PlasmaEntity> {
    public PlasmaRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new DefaultedEntityGeoModel(ResourceLocation.fromNamespaceAndPath((String)"mekanism_weaponry", (String)"plasma")));
    }

    public void preRender(PoseStack poseStack, PlasmaEntity animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        RenderUtil.faceRotation((PoseStack)poseStack, (Entity)animatable, (float)partialTick);
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    public boolean shouldRender(PlasmaEntity livingEntity, Frustum camera, double camX, double camY, double camZ) {
        if (livingEntity.distanceToSqr(camX, camY, camZ) < 2.0) {
            return false;
        }
        return super.shouldRender((Entity)livingEntity, camera, camX, camY, camZ);
    }

    @Nullable
    public RenderType getRenderType(PlasmaEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.breezeEyes((ResourceLocation)this.getTextureLocation((Entity)animatable));
    }
}

