/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.client.screen;

import com.github.x3r.mekanism_weaponry.common.menu.WeaponWorkbenchMenu;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WeaponWorkbenchScreen
extends AbstractContainerScreen<WeaponWorkbenchMenu> {
    private static final ResourceLocation MENU_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"mekanism_weaponry", (String)"textures/gui/container/weapon_workbench.png");

    public WeaponWorkbenchScreen(WeaponWorkbenchMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(MENU_RESOURCE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (((WeaponWorkbenchMenu)this.getMenu()).getSlot(0).hasItem()) {
            this.renderItemPreview(guiGraphics, ((WeaponWorkbenchMenu)this.getMenu()).getSlot(0).getItem(), mouseX, mouseY);
        }
    }

    private void renderItemPreview(GuiGraphics guiGraphics, ItemStack stack, int mouseX, int mouseY) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)guiGraphics.guiWidth() / 2.0f, (float)guiGraphics.guiHeight() / 2.0f - 30.0f, 100.0f);
        guiGraphics.pose().scale(20.0f, -20.0f, 20.0f);
        float xMouseAngle = -((float)Math.atan(((float)guiGraphics.guiWidth() / 2.0f - (float)mouseX) / 200.0f));
        float yMouseAngle = -((float)Math.atan(((float)guiGraphics.guiHeight() / 2.0f - (float)mouseY - 20.0f) / 200.0f));
        guiGraphics.pose().mulPose(Axis.YP.rotation(1.5707964f * xMouseAngle + 1.5707964f));
        guiGraphics.pose().mulPose(Axis.ZP.rotation(1.5707964f * yMouseAngle));
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, 0xF000F0, OverlayTexture.NO_OVERLAY, guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), (Level)Minecraft.getInstance().level, 0);
        guiGraphics.pose().popPose();
    }
}

