/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.entity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class GunProjectileEntity
extends Projectile {
    protected final double damage;
    protected final Function<Entity, DamageSource> damageSource;

    protected GunProjectileEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
        this.damage = 0.0;
        this.damageSource = null;
    }

    public GunProjectileEntity(EntityType<? extends Projectile> pEntityType, Level pLevel, double damage, Function<Entity, DamageSource> damageSource) {
        super(pEntityType, pLevel);
        this.noPhysics = true;
        this.setNoGravity(true);
        this.damage = damage;
        this.damageSource = damageSource;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.tickCount > 300) {
                this.remove(Entity.RemovalReason.DISCARDED);
                return;
            }
            this.handleCollisions();
        }
        this.setPos(this.position().add(this.getDeltaMovement()));
    }

    private void handleCollisions() {
        Vec3 startVec = this.position();
        Vec3 endVec = this.position().add(this.getDeltaMovement());
        List<BlockHitResult> blockCollisions = this.traceBlockCollisions(startVec, endVec);
        List<EntityHitResult> entityCollisions = this.traceEntityCollisions(startVec, endVec, this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0)));
        ArrayList<Object> collisions = new ArrayList<Object>();
        collisions.addAll(blockCollisions);
        collisions.addAll(entityCollisions);
        collisions.sort(Comparator.comparingDouble(o -> o.getLocation().distanceToSqr(startVec)));
        for (HitResult hitResult : collisions) {
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                this.handleEntityCollision(entityHitResult);
            }
            if (!(hitResult instanceof BlockHitResult)) continue;
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            this.handleBlockCollision(blockHitResult);
        }
    }

    private void handleEntityCollision(EntityHitResult hitResult) {
        Entity entity = hitResult.getEntity();
        if (!entity.equals((Object)this.getOwner())) {
            entity.hurt(this.damageSource.apply(this.getOwner()), (float)this.damage);
            Vec3 pos = hitResult.getLocation();
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.REDSTONE_BLOCK.defaultBlockState()), pos.x, pos.y, pos.z, 15, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void handleBlockCollision(BlockHitResult hitResult) {
        BlockState state = this.level().getBlockState(hitResult.getBlockPos());
        if (state.getCollisionShape((BlockGetter)this.level(), hitResult.getBlockPos(), CollisionContext.empty()).isEmpty() || state.getVisualShape((BlockGetter)this.level(), hitResult.getBlockPos(), CollisionContext.empty()).isEmpty()) {
            return;
        }
        Vec3 pos = hitResult.getLocation();
        ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.level().getBlockState(hitResult.getBlockPos())), pos.x, pos.y, pos.z, 15, 0.0, 0.0, 0.0, 1.0);
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public List<BlockHitResult> traceBlockCollisions(Vec3 startVec, Vec3 endVec) {
        ArrayList<BlockHitResult> collisions = new ArrayList<BlockHitResult>();
        double scale = this.getBoundingBox().getSize() / endVec.subtract(startVec).length();
        Vec3 increment = endVec.subtract(startVec).scale(scale);
        int i = 0;
        while ((double)i < 1.0 / scale) {
            Vec3 vPos = startVec.add(increment.scale((double)i));
            BlockPos pos = new BlockPos(Mth.floor((double)vPos.x), Mth.floor((double)vPos.y), Mth.floor((double)vPos.z));
            BlockState state = this.level().getBlockState(pos);
            if (!state.isAir()) {
                collisions.add(new BlockHitResult(vPos, Direction.getNearest((double)vPos.x, (double)vPos.y, (double)vPos.z).getOpposite(), pos, true));
            }
            ++i;
        }
        return collisions;
    }

    public List<EntityHitResult> traceEntityCollisions(Vec3 startVec, Vec3 endVec, List<Entity> candidates) {
        ArrayList<EntityHitResult> collisions = new ArrayList<EntityHitResult>();
        candidates.forEach(entity -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                AABB box = livingEntity.getBoundingBox().inflate((double)0.1f);
                Optional hitPos = box.clip(startVec, endVec);
                hitPos.ifPresent(vec3 -> collisions.add(new EntityHitResult((Entity)livingEntity, vec3)));
            }
        });
        return collisions;
    }
}

