/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.item;

import com.github.x3r.mekanism_weaponry.common.item.GunItem;
import com.github.x3r.mekanism_weaponry.common.registry.DataComponentRegistry;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.IItemDecorator;

public abstract class AmmoGunItem
extends GunItem {
    protected final int maxAmmo;

    protected AmmoGunItem(Item.Properties pProperties, int cooldown, int energyUsage, int reloadTime, int maxAmmo) {
        super(pProperties.component((DataComponentType)DataComponentRegistry.LOADED_AMMO.get(), (Object)new DataComponentLoadedAmmo()), cooldown, energyUsage, reloadTime);
        this.maxAmmo = maxAmmo;
    }

    @Override
    public boolean isReady(ItemStack stack, ServerPlayer player, Level level) {
        return this.hasAmmo(stack) && super.isReady(stack, player, level);
    }

    @Override
    public boolean canReload(ItemStack stack, ServerPlayer serverPlayer) {
        return super.canReload(stack, serverPlayer) && !this.getFirstAmmoStack(stack, serverPlayer).isEmpty();
    }

    public ItemStack getLoadedAmmo(ItemStack gunStack) {
        return ((DataComponentLoadedAmmo)gunStack.get(DataComponentRegistry.LOADED_AMMO)).stack();
    }

    public void setLoadedAmmo(ItemStack gunStack, ItemStack ammoStack) {
        gunStack.set(DataComponentRegistry.LOADED_AMMO, (Object)new DataComponentLoadedAmmo(ammoStack));
    }

    public void loadAmmo(ItemStack gunStack, ServerPlayer player) {
        ItemStack ammoInGun = this.getLoadedAmmo(gunStack);
        ItemStack ammoStack = this.getFirstAmmoStack(gunStack, player);
        int i = ammoInGun.getCount() + ammoStack.getCount() - this.maxAmmo;
        this.setLoadedAmmo(gunStack, new ItemStack((ItemLike)ammoStack.getItem(), Math.min(ammoInGun.getCount() + ammoStack.getCount(), this.maxAmmo)));
        ammoStack.setCount(Math.max(0, i));
        if (ammoInGun.getCount() < this.maxAmmo && !this.getFirstAmmoStack(gunStack, player).isEmpty()) {
            this.loadAmmo(gunStack, player);
        }
    }

    public abstract Predicate<ItemStack> isValidAmmo(ItemStack var1);

    public boolean ammoFitsInGun(ItemStack gunStack, ItemStack ammoStack) {
        ItemStack stackInGun = this.getLoadedAmmo(gunStack);
        if (stackInGun.isEmpty()) {
            return true;
        }
        return stackInGun.getCount() < this.maxAmmo && ammoStack.is(stackInGun.getItem());
    }

    public boolean hasAmmo(ItemStack gunStack) {
        return !this.getLoadedAmmo(gunStack).isEmpty();
    }

    public ItemStack getFirstAmmoStack(ItemStack gunStack, ServerPlayer player) {
        ItemStack offHandStack = player.getOffhandItem();
        if (this.isValidAmmo(gunStack).test(offHandStack) && this.ammoFitsInGun(gunStack, offHandStack)) {
            return offHandStack;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!this.isValidAmmo(gunStack).test(stack) || !this.ammoFitsInGun(gunStack, stack)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static IItemDecorator decorator() {
        return (guiGraphics, font, stack, xOffset, yOffset) -> {
            AmmoGunItem item = (AmmoGunItem)stack.getItem();
            float f = Math.min(1.0f, (float)item.getLoadedAmmo(stack).getCount() / (float)item.maxAmmo);
            guiGraphics.fill(RenderType.guiOverlay(), xOffset + 2, yOffset + 13, xOffset + 2 + 13, yOffset + 13 + 2, -16777216);
            int i = 0;
            while ((float)i < 13.0f * f) {
                guiGraphics.fill(RenderType.guiOverlay(), xOffset + 2 + i, yOffset + 13, xOffset + 2 + i + 1, yOffset + 13 + 1, -1);
                ++i;
            }
            return true;
        };
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"mekanism_weaponry.tooltip.gun_loaded_ammo").withColor(12745632).append((Component)Component.literal((String)String.format("%d/%d Steel Rods", this.getLoadedAmmo(stack).getCount(), this.maxAmmo)).withColor(0xFFFFFF)));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public record DataComponentLoadedAmmo(ItemStack stack) {
        public DataComponentLoadedAmmo() {
            this(ItemStack.EMPTY);
        }
    }
}

