/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.item;

import com.github.x3r.mekanism_weaponry.common.item.GunItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.HeatPerShotChipItem;
import com.github.x3r.mekanism_weaponry.common.registry.DataComponentRegistry;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.IItemDecorator;

public abstract class HeatGunItem
extends GunItem {
    public static final float MAX_HEAT = 100.0f;
    private final float heatPerShot;
    private static final int[] COLORS = new int[]{-11931873, -10953442, -10040803, -9062372, -8149477, -7171302, -6258407, -5279976, -4367337, -3454442, -2476011, -1497836, -584941};

    protected HeatGunItem(Item.Properties pProperties, int cooldown, int energyUsage, int reloadTime, float heatPerShot) {
        super(pProperties.component((DataComponentType)DataComponentRegistry.HEAT.get(), (Object)Float.valueOf(0.0f)), cooldown, energyUsage, reloadTime);
        this.heatPerShot = heatPerShot;
    }

    @Override
    public boolean canInstallAddon(ItemStack gunStack, ItemStack addonStack) {
        return addonStack.getItem().getClass().equals(HeatPerShotChipItem.class);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float heat = this.getHeat(stack);
            if (heat > 0.0f) {
                if (!this.isShooting(stack)) {
                    this.setHeat(stack, heat - 1.0f);
                }
                if (heat > 100.0f) {
                    this.tryStartReload(stack, player);
                }
            }
            if ((double)heat < 0.05) {
                this.setHeat(stack, 0.0f);
            }
        }
    }

    @Override
    public void addStatsTooltip(ItemStack stack, List<Component> tooltipComponents) {
        super.addStatsTooltip(stack, tooltipComponents);
        tooltipComponents.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"mekanism_weaponry.tooltip.gun_heat_per_shot")).append(": ").withColor(9030029).append((Component)Component.literal((String)String.format("%.2f heat", Float.valueOf(this.getHeatPerShot(stack)))).withColor(0xFFFFFF)));
    }

    @Override
    public boolean isReady(ItemStack stack, ServerPlayer player, Level level) {
        return super.isReady(stack, player, level) && !this.isOverheated(stack);
    }

    public float getHeatPerShot(ItemStack stack) {
        List<ItemStack> heatPerShotAddon = this.getAddonsOfType(stack, HeatPerShotChipItem.class);
        float modifiedHeatPerShot = this.heatPerShot;
        for (ItemStack addonStack : heatPerShotAddon) {
            modifiedHeatPerShot *= ((HeatPerShotChipItem)addonStack.getItem()).mul() / 8.0f;
        }
        return modifiedHeatPerShot;
    }

    public float getHeat(ItemStack stack) {
        return ((Float)stack.get((DataComponentType)DataComponentRegistry.HEAT.get())).floatValue();
    }

    public void setHeat(ItemStack stack, float heat) {
        stack.set((DataComponentType)DataComponentRegistry.HEAT.get(), (Object)Float.valueOf(heat));
    }

    public boolean isOverheated(ItemStack stack) {
        return this.getHeat(stack) > 100.0f;
    }

    public static IItemDecorator decorator() {
        return (guiGraphics, font, stack, xOffset, yOffset) -> {
            HeatGunItem item = (HeatGunItem)stack.getItem();
            float f = Math.min(1.0f, item.getHeat(stack) / 100.0f);
            int i = 0;
            while ((float)i < 13.0f * f) {
                guiGraphics.fill(RenderType.guiOverlay(), xOffset + 2 + i, yOffset + 13, xOffset + 2 + i + 1, yOffset + 13 + 1, COLORS[i]);
                guiGraphics.fill(RenderType.guiOverlay(), xOffset + 2 + i, yOffset + 14, xOffset + 2 + i + 1, yOffset + 14 + 1, -16777216);
                ++i;
            }
            return true;
        };
    }
}

