/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.item;

import com.github.x3r.mekanism_weaponry.MekanismWeaponryConfig;
import com.github.x3r.mekanism_weaponry.client.ClientSetup;
import com.github.x3r.mekanism_weaponry.client.renderer.PlasmaRifleRenderer;
import com.github.x3r.mekanism_weaponry.common.entity.PlasmaEntity;
import com.github.x3r.mekanism_weaponry.common.item.HeatGunItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.EnergyUsageChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.FireRateChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.PaintBucketItem;
import com.github.x3r.mekanism_weaponry.common.packet.ActivateGunPayload;
import com.github.x3r.mekanism_weaponry.common.registry.DataComponentRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.SoundRegistry;
import com.github.x3r.mekanism_weaponry.common.scheduler.Scheduler;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PlasmaRifleItem
extends HeatGunItem
implements GeoItem {
    private static final RawAnimation IDLE = RawAnimation.begin().then("idle", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private static final RawAnimation RELOAD = RawAnimation.begin().then("reload", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation SHOOT = RawAnimation.begin().then("shot", Animation.LoopType.PLAY_ONCE);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PlasmaRifleItem(Item.Properties pProperties) {
        super(pProperties, MekanismWeaponryConfig.CONFIG.getPlasmaRifleCooldown(), MekanismWeaponryConfig.CONFIG.getPlasmaRifleEnergyUsage(), MekanismWeaponryConfig.CONFIG.getPlasmaRifleReloadTime(), MekanismWeaponryConfig.CONFIG.getPlasmaRifleHeatPerShot());
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public void serverShoot(ItemStack stack, ServerPlayer player) {
        Level level = player.level();
        Vec3 pos = player.getEyePosition().add(player.getLookAngle().normalize().scale(0.1));
        if (this.isReady(stack, player, level)) {
            stack.set(DataComponentRegistry.IS_SHOOTING, (Object)true);
            this.setLastShotTick(stack, level.getGameTime());
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ActivateGunPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PlasmaEntity plasma = new PlasmaEntity(player, pos, MekanismWeaponryConfig.CONFIG.getPlasmaRifleDamage());
            plasma.setDeltaMovement(player.getLookAngle().normalize().scale(3.0));
            level.addFreshEntity((Entity)plasma);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundRegistry.PLASMA_RIFLE_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.getEnergyStorage(stack).extractEnergy(this.getEnergyUsage(stack), false);
            this.setHeat(stack, this.getHeat(stack) + this.getHeatPerShot(stack));
        } else {
            if (!this.hasSufficientEnergy(stack)) {
                level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundRegistry.GUN_OUT_OF_ENERGY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (this.isOverheated(stack)) {
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.REDSTONE_TORCH_BURNOUT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            stack.set(DataComponentRegistry.IS_SHOOTING, (Object)false);
        }
    }

    @Override
    public void clientShoot(ItemStack stack, Player player) {
        this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "shoot");
        ClientSetup.addRecoil(5);
    }

    @Override
    public void serverReload(ItemStack stack, ServerPlayer player) {
        player.getCooldowns().addCooldown(stack.getItem(), this.getReloadTime(stack));
        Scheduler.schedule(() -> {
            if (player.getInventory().contains(stack)) {
                this.setHeat(stack, 0.0f);
                player.serverLevel().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }, 45);
    }

    @Override
    public void clientReload(ItemStack stack, Player player) {
        this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "reload");
    }

    @Override
    public boolean canInstallAddon(ItemStack gunStack, ItemStack addonStack) {
        if (addonStack.getItem().getClass().equals(EnergyUsageChipItem.class)) {
            return true;
        }
        if (addonStack.getItem().getClass().equals(FireRateChipItem.class)) {
            return true;
        }
        if (addonStack.getItem().getClass().equals(PaintBucketItem.class)) {
            return true;
        }
        return super.canInstallAddon(gunStack, addonStack);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private PlasmaRifleRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PlasmaRifleRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 1, state -> {
            if (((ItemDisplayContext)state.getData(DataTickets.ITEM_RENDER_PERSPECTIVE)).firstPerson()) {
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }).receiveTriggeredAnimations().triggerableAnim("reload", RELOAD).triggerableAnim("shoot", SHOOT));
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

