/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.item;

import com.github.x3r.mekanism_weaponry.MekanismWeaponryConfig;
import com.github.x3r.mekanism_weaponry.client.ClientSetup;
import com.github.x3r.mekanism_weaponry.client.renderer.RailgunRenderer;
import com.github.x3r.mekanism_weaponry.common.datagen.MWItemTagsProvider;
import com.github.x3r.mekanism_weaponry.common.entity.RodEntity;
import com.github.x3r.mekanism_weaponry.common.item.AmmoGunItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.EnergyUsageChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.FireRateChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.PaintBucketItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.ScopeAddonItem;
import com.github.x3r.mekanism_weaponry.common.packet.ActivateGunPayload;
import com.github.x3r.mekanism_weaponry.common.registry.DataComponentRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.SoundRegistry;
import com.github.x3r.mekanism_weaponry.common.scheduler.Scheduler;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RailgunItem
extends AmmoGunItem
implements GeoItem {
    private static final RawAnimation DEFAULT_MODE = RawAnimation.begin().then("default_mode", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private static final RawAnimation SECOND_MODE = RawAnimation.begin().then("second_mode", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private static final RawAnimation SWITCH_TO_DEFAULT = RawAnimation.begin().then("switch_to_default", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private static final RawAnimation SWITCH_TO_SECOND = RawAnimation.begin().then("switch_to_second", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private static final RawAnimation SHOT_DEFAULT = RawAnimation.begin().then("shot_default", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation SHOT_SECOND = RawAnimation.begin().then("shot_second", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation RELOAD = RawAnimation.begin().then("reload", Animation.LoopType.PLAY_ONCE);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RailgunItem(Item.Properties pProperties) {
        super(pProperties.component(DataComponentRegistry.RAILGUN_SECONDARY_MODE, (Object)false), MekanismWeaponryConfig.CONFIG.getRailgunCooldown(), MekanismWeaponryConfig.CONFIG.getRailgunEnergyUsage(), MekanismWeaponryConfig.CONFIG.getRailgunReloadTime(), MekanismWeaponryConfig.CONFIG.getRailgunMaxAmmo());
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public Predicate<ItemStack> isValidAmmo(ItemStack gunStack) {
        return stack -> stack.is(MWItemTagsProvider.STEEL_ROD);
    }

    @Override
    public void serverShoot(ItemStack stack, ServerPlayer player) {
        Level level = player.level();
        Vec3 lookAngle = player.getLookAngle();
        Vec3 pos = player.getEyePosition().add(lookAngle.normalize().scale(0.1));
        if (this.isReady(stack, player, level)) {
            this.setLastShotTick(stack, level.getGameTime());
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ActivateGunPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            double dmg = MekanismWeaponryConfig.CONFIG.getRailgunDamage() * this.getScale(stack);
            RodEntity rod = new RodEntity(player, pos, dmg, this.isSecondMode(stack));
            rod.setDeltaMovement(lookAngle.add(0.0, 0.015, 0.0).normalize().scale(3.0 * this.getScale(stack)));
            level.addFreshEntity((Entity)rod);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundRegistry.RAILGUN_SHOOT.get(), SoundSource.PLAYERS, 3.0f, 1.0f);
            this.setLoadedAmmo(stack, this.getLoadedAmmo(stack).copyWithCount(this.getLoadedAmmo(stack).getCount() - 1));
            this.getEnergyStorage(stack).extractEnergy((int)((double)this.getEnergyUsage(stack) * this.getScale(stack)), false);
            if (this.isSecondMode(stack)) {
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 4));
            }
        } else {
            if (!this.hasSufficientEnergy(stack)) {
                level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundRegistry.GUN_OUT_OF_ENERGY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (!this.hasAmmo(stack)) {
                this.tryStartReload(stack, player);
            }
            stack.set(DataComponentRegistry.IS_SHOOTING, (Object)false);
        }
    }

    private double getScale(ItemStack stack) {
        return this.isSecondMode(stack) ? MekanismWeaponryConfig.CONFIG.getRailgunSecondModeScale() : 1.0;
    }

    @Override
    public void clientShoot(ItemStack stack, Player player) {
        if (this.isSecondMode(stack)) {
            this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "shot_second");
            player.push(player.getLookAngle().scale(-0.75));
        } else {
            this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "shot_default");
        }
        ClientSetup.addRecoil(10);
    }

    @Override
    public void serverReload(ItemStack stack, ServerPlayer player) {
        player.getCooldowns().addCooldown(stack.getItem(), this.getReloadTime(stack));
        player.serverLevel().playSound(null, player.getX(), player.getY(), player.getZ(), SoundRegistry.RAILGUN_RELOAD, SoundSource.PLAYERS, 1.0f, 1.0f);
        Scheduler.schedule(() -> {
            if (player.getInventory().contains(stack)) {
                this.loadAmmo(stack, player);
            }
        }, 35);
    }

    @Override
    public void clientReload(ItemStack stack, Player player) {
        this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "reload");
    }

    @Override
    public boolean canInstallAddon(ItemStack gunStack, ItemStack addonStack) {
        if (addonStack.getItem().getClass().equals(EnergyUsageChipItem.class)) {
            return true;
        }
        if (addonStack.getItem().getClass().equals(FireRateChipItem.class)) {
            return true;
        }
        if (addonStack.getItem().getClass().equals(PaintBucketItem.class)) {
            return true;
        }
        return addonStack.getItem().getClass().equals(ScopeAddonItem.class);
    }

    public boolean isSecondMode(ItemStack stack) {
        return (Boolean)stack.get((DataComponentType)DataComponentRegistry.RAILGUN_SECONDARY_MODE.get());
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (player.isCrouching()) {
            boolean secondMode = (Boolean)stack.get((DataComponentType)DataComponentRegistry.RAILGUN_SECONDARY_MODE.get());
            if (!secondMode) {
                this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "switch_to_second");
                stack.set((DataComponentType)DataComponentRegistry.RAILGUN_SECONDARY_MODE.get(), (Object)true);
            } else {
                this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "switch_to_default");
                stack.set((DataComponentType)DataComponentRegistry.RAILGUN_SECONDARY_MODE.get(), (Object)false);
            }
            player.getCooldowns().addCooldown(stack.getItem(), 20);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return super.use(level, player, usedHand);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private RailgunRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new RailgunRenderer();
                }
                return this.renderer;
            }
        });
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"mekanism_weaponry.tooltip.railgun_mode_label").withColor(7798566).append((Component)Component.translatable((String)(this.isSecondMode(stack) ? "mekanism_weaponry.tooltip.railgun_second_mode" : "mekanism_weaponry.tooltip.railgun_first_mode")).withStyle(Style.EMPTY.withColor(0xFFFFFF)).append((Component)Component.literal((String)" [SHIFT + RMB]").withColor(0x5C5C5C))));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 1, state -> {
            if (!state.getController().isPlayingTriggeredAnimation()) {
                if (!this.isSecondMode((ItemStack)state.getData(DataTickets.ITEMSTACK))) {
                    state.setAnimation(DEFAULT_MODE);
                } else {
                    state.setAnimation(SECOND_MODE);
                }
            }
            if (((ItemDisplayContext)state.getData(DataTickets.ITEM_RENDER_PERSPECTIVE)).firstPerson()) {
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }).receiveTriggeredAnimations().triggerableAnim("switch_to_default", SWITCH_TO_DEFAULT).triggerableAnim("switch_to_second", SWITCH_TO_SECOND).triggerableAnim("shot_default", SHOT_DEFAULT).triggerableAnim("shot_second", SHOT_SECOND).triggerableAnim("reload", RELOAD));
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

