/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.mixin;

import com.github.x3r.mekanism_weaponry.common.item.GunItem;
import com.github.x3r.mekanism_weaponry.common.packet.ActivateGunPayload;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Final
    public Options options;
    @Shadow
    @Final
    public MouseHandler mouseHandler;
    @Shadow
    @Nullable
    public ClientLevel level;

    @Inject(method={"handleKeybinds", "m_91279_"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;continueAttack(Z)V")}, cancellable=true)
    private void handleKeybinds(CallbackInfo ci) {
        if (this.player == null) {
            return;
        }
        ItemStack stack = this.player.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack.getItem() instanceof GunItem && this.mouseHandler.isMouseGrabbed() && this.options.keyAttack.isDown()) {
            this.leftClickGun(stack);
            ci.cancel();
        }
    }

    private void leftClickGun(ItemStack stack) {
        GunItem item;
        Item item2 = stack.getItem();
        if (item2 instanceof GunItem && (item = (GunItem)item2).isOffCooldown(stack, this.level.getGameTime())) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ActivateGunPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            item.setLastShotTick(stack, this.level.getGameTime());
        }
    }
}

