/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.utility.VacuumPumpBlockEntity;
import me.desht.pneumaticcraft.common.inventory.VacuumPumpMenu;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class VacuumPumpScreen
extends AbstractPneumaticCraftContainerScreen<VacuumPumpMenu, VacuumPumpBlockEntity> {
    public VacuumPumpScreen(VacuumPumpMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_VACUUM_PUMP;
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        super.renderLabels(graphics, x, y);
        graphics.drawString(this.font, "+", 32, 47, -16733696, false);
        graphics.drawString(this.font, "-", 138, 47, -65536, false);
        float pressure = PNCCapabilities.getAirHandler(this.te, ((VacuumPumpBlockEntity)this.te).getInputSide()).orElseThrow().getPressure();
        PressureGaugeRenderer2D.drawPressureGauge(graphics, this.font, -1.0f, 7.0f, 5.0f, 2.0f, pressure, this.imageWidth / 5, this.imageHeight / 5 + 4);
        float vacPressure = PNCCapabilities.getAirHandler(this.te, ((VacuumPumpBlockEntity)this.te).getVacuumSide()).orElseThrow(RuntimeException::new).getPressure();
        PressureGaugeRenderer2D.drawPressureGauge(graphics, this.font, -1.0f, 7.0f, 5.0f, -1.0f, vacPressure, this.imageWidth * 4 / 5, this.imageHeight / 5 + 4);
    }

    @Override
    protected PointXY getGaugeLocation() {
        return null;
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        IAirHandlerMachine inputAirHandler = PNCCapabilities.getAirHandler(this.te, ((VacuumPumpBlockEntity)this.te).getInputSide()).orElseThrow();
        IAirHandlerMachine vacuumHandler = PNCCapabilities.getAirHandler(this.te, ((VacuumPumpBlockEntity)this.te).getVacuumSide()).orElseThrow();
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.vacuumPump.inputPressure", PneumaticCraftUtils.roundNumberTo(inputAirHandler.getPressure(), 2)));
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.vacuumPump.vacuumPressure", PneumaticCraftUtils.roundNumberTo(vacuumHandler.getPressure(), 2)));
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.vacuumPump.inputAir", String.format("%,d", inputAirHandler.getAir())));
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.vacuumPump.vacuumAir", String.format("%,d", vacuumHandler.getAir())));
        int volume = inputAirHandler.getVolume();
        int upgrades = ((VacuumPumpBlockEntity)this.te).getUpgrades(ModUpgrades.VOLUME.get());
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.baseVolume", String.format("%,d", 2000)));
        if (volume > inputAirHandler.getBaseVolume()) {
            pressureStatText.add((Component)Component.literal((String)("\u25b6 " + upgrades + " x ")).append(ModUpgrades.VOLUME.get().getItemStack().getHoverName()));
            pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.effectiveVolume", String.format("%,d", volume)));
        }
        if (((VacuumPumpBlockEntity)this.te).turning) {
            int suction = Math.round(4.0f * ((VacuumPumpBlockEntity)this.te).getSpeedMultiplierFromUpgrades());
            pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.suction", String.format("%,d", suction)));
        }
    }

    @Override
    protected void addProblems(List<Component> textList) {
        super.addProblems(textList);
        float pressure = PNCCapabilities.getAirHandler(this.te, ((VacuumPumpBlockEntity)this.te).getInputSide()).orElseThrow().getPressure();
        if (pressure < 2.0f) {
            textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.notEnoughPressure", new Object[0]));
            textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.applyPressure", Float.valueOf(2.0f)).withStyle(ChatFormatting.BLACK));
        }
    }
}

