/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

public class WidgetTextField
extends EditBox {
    private boolean passwordBox;

    public WidgetTextField(Font fontRenderer, int x, int y, int width, int height) {
        super(fontRenderer, x, y, width, height, (Component)Component.empty());
    }

    public WidgetTextField(Font fontRenderer, int x, int y, int width) {
        Objects.requireNonNull(fontRenderer);
        super(fontRenderer, x, y, width, 9 + 3, (Component)Component.empty());
    }

    public WidgetTextField setAsPasswordBox() {
        this.passwordBox = true;
        return this;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        String oldText = this.getValue();
        int oldCursorPos = this.getCursorPosition();
        if (this.passwordBox) {
            this.setValue(StringUtils.repeat((char)'*', (int)oldText.length()));
            this.moveCursorTo(oldCursorPos, false);
        }
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        if (this.passwordBox) {
            this.setValue(oldText);
            this.moveCursorTo(oldCursorPos, false);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isHovered() && button == 1) {
            this.setValue("");
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

