/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractAssemblyRenderer;
import me.desht.pneumaticcraft.common.block.entity.processing.AssemblyLaserBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class AssemblyLaserRenderer
extends AbstractAssemblyRenderer<AssemblyLaserBlockEntity> {
    private final ModelPart baseTurn;
    private final ModelPart baseTurn2;
    private final ModelPart armBase;
    private final ModelPart armMiddle;
    private final ModelPart laserBase;
    private final ModelPart laser;
    private static final String BASETURN = "baseTurn";
    private static final String BASETURN2 = "baseTurn2";
    private static final String ARMBASE = "armBase";
    private static final String ARMMIDDLE = "armMiddle";
    private static final String LASERBASE = "laserBase";
    private static final String LASER = "laser";

    public AssemblyLaserRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.bakeLayer(PNCModelLayers.ASSEMBLY_LASER);
        this.baseTurn = root.getChild(BASETURN);
        this.baseTurn2 = root.getChild(BASETURN2);
        this.armBase = root.getChild(ARMBASE);
        this.armMiddle = root.getChild(ARMMIDDLE);
        this.laserBase = root.getChild(LASERBASE);
        this.laser = root.getChild(LASER);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(BASETURN, CubeListBuilder.create().texOffs(0, 0).addBox("baseTurn_0", -1.0f, 0.0f, -1.0f, 9, 1, 9, 0, 0).mirror(), PartPose.offset((float)-3.5f, (float)22.0f, (float)-3.5f));
        partdefinition.addOrReplaceChild(BASETURN2, CubeListBuilder.create().texOffs(0, 0).addBox("baseTurn2_0", -2.0f, -0.5f, 0.5f, 2, 6, 3, new CubeDeformation(0.2f), 0, 30).addBox("baseTurn2_1", -2.0f, 3.75f, -2.0f, 2, 2, 8, 0, 10).addBox("baseTurn2_2", 4.0f, -0.5f, 0.5f, 2, 6, 3, new CubeDeformation(0.2f), 10, 30).addBox("baseTurn2_3", 4.0f, 3.75f, -2.0f, 2, 2, 8, 0, 20).mirror(), PartPose.offset((float)-2.0f, (float)17.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild(ARMBASE, CubeListBuilder.create().texOffs(0, 0).addBox("armBase_0", 2.0f, 0.0f, 1.0f, 2, 2, 5, new CubeDeformation(0.3f), 0, 49).addBox("armBase_1", 1.5f, -0.5f, -0.5f, 3, 3, 3, 0, 43).addBox("armBase_2", 1.5f, -0.5f, 5.5f, 3, 3, 3, 12, 43).addBox("armBase_3", -1.5f, 0.0f, 0.0f, 9, 2, 2, 0, 39).mirror(), PartPose.offset((float)-3.0f, (float)17.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild(ARMMIDDLE, CubeListBuilder.create().texOffs(0, 0).addBox("armMiddle_0", 0.0f, 2.0f, 0.0f, 2, 13, 2, 28, 10).addBox("armMiddle_1", 0.0f, 0.0f, 0.0f, 2, 2, 2, new CubeDeformation(0.3f), 12, 24).addBox("armMiddle_2", 0.0f, 15.0f, 0.0f, 2, 2, 2, new CubeDeformation(0.3f), 0, 24).addBox("armMiddle_3", -0.5f, 15.0f, 0.0f, 3, 2, 2, 14, 52).addBox("armMiddle_4", 4.0f, 0.5f, 0.5f, 1, 7, 1, 60, 38).addBox("armMiddle_5", 2.0f, 6.5f, 0.5f, 2, 1, 1, 54, 38).mirror(), PartPose.offset((float)-4.0f, (float)2.0f, (float)5.0f));
        partdefinition.addOrReplaceChild(LASERBASE, CubeListBuilder.create().texOffs(0, 0).addBox("laserBase_0", 2.5f, -1.5f, -1.0f, 3, 6, 6, 46, 15).addBox("laserBase_1", 3.5f, -0.5f, -0.5f, 3, 6, 5, 48, 27).addBox("laserBase_2", 2.0f, 0.5f, 0.5f, 2, 1, 1, new CubeDeformation(0.3f), 48, 38), PartPose.offset((float)-4.0f, (float)2.0f, (float)5.0f));
        partdefinition.addOrReplaceChild(LASER, CubeListBuilder.create().texOffs(0, 0).addBox("laser_0", -0.5f, -21.5f, 1.0f, 1, 1, 27, 8, 36).mirror(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void renderModel(AssemblyLaserBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float[] angles = new float[5];
        for (int i = 0; i < 5; ++i) {
            angles[i] = Mth.lerp((float)partialTicks, (float)te.oldAngles[i], (float)te.angles[i]);
        }
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)Textures.MODEL_ASSEMBLY_LASER_AND_DRILL));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(angles[0]));
        this.baseTurn.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.baseTurn2.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.translate(0.0f, 1.125f, 0.0f);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(angles[1]));
        matrixStackIn.translate(0.0f, -1.125f, 0.0f);
        this.armBase.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.translate(0.0f, 1.125f, 0.375f);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(angles[2]));
        matrixStackIn.translate(0.0f, -1.125f, -0.375f);
        this.armMiddle.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.translate(0.0f, 0.1875f, 0.375f);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(angles[3]));
        matrixStackIn.translate(0.0f, -0.1875f, -0.375f);
        this.laserBase.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        if (te.isLaserOn) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0, 0.140625, 0.0625);
            matrixStackIn.scale(0.25f, 0.25f, 0.25f);
            this.laser.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
        }
    }
}

