/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.common.block.entity.compressor.SolarCompressorBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class SolarCompressorRenderer
extends AbstractBlockEntityModelRenderer<SolarCompressorBlockEntity> {
    private final ModelPart panels;
    private final ModelPart support;
    private final ModelPart base;

    public SolarCompressorRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.bakeLayer(PNCModelLayers.SOLAR_COMPRESSOR);
        this.panels = root.getChild("panels");
        this.support = root.getChild("support");
        this.base = root.getChild("base");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition panels = partdefinition.addOrReplaceChild("panels", CubeListBuilder.create().texOffs(14, 53).addBox(-2.0f, -1.5f, 0.5f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(14, 44).addBox(-2.0f, -1.5f, -2.5f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(15, 42).addBox(-8.0f, -0.5f, 2.0f, 16.0f, 1.0f, 20.0f, new CubeDeformation(0.0f)).texOffs(15, 17).addBox(-8.0f, -0.5f, -22.0f, 16.0f, 1.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition support = partdefinition.addOrReplaceChild("support", CubeListBuilder.create().texOffs(3, 42).addBox(-1.0f, -16.0f, -1.0f, 2.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 105).addBox(-8.0f, -16.0f, -4.0f, 16.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(43, 68).addBox(-3.0f, -17.0f, -3.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 67).addBox(5.0f, -17.0f, -5.0f, 1.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(24, 67).addBox(-6.0f, -17.0f, -5.0f, 1.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(52, 69).addBox(-5.0f, -13.0f, -8.0f, 10.0f, 10.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(50, 100).addBox(-7.0f, -15.0f, -7.0f, 14.0f, 14.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(0, 81).addBox(-8.0f, -1.0f, -8.0f, 16.0f, 1.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    @Override
    void renderModel(SolarCompressorBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)Textures.MODEL_SOLAR_COMPRESSOR));
        if (!te.isBounding(te)) {
            float panelAngle = 57.295776f * te.getLevel().getSunAngle((float)te.getLevel().getDayTime());
            matrixStackIn.translate(0.0f, -0.375f, 0.0f);
            if (panelAngle < 90.0f || panelAngle > 270.0f) {
                matrixStackIn.mulPose(Axis.ZN.rotationDegrees(panelAngle));
            } else {
                matrixStackIn.mulPose(Axis.ZN.rotationDegrees(90.0f - (panelAngle - 90.0f)));
            }
            matrixStackIn.translate(0.0f, 0.375f, 0.0f);
            this.panels.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        }
    }
}

