/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.JackHammerItem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;

public class JackhammerOverlay
implements LayeredDraw.Layer {
    public void render(GuiGraphics graphics, DeltaTracker partialTicks) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !(player.getMainHandItem().getItem() instanceof JackHammerItem) || !Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return;
        }
        long timeDelta = player.level().getGameTime() - JackHammerItem.getLastModeSwitchTime();
        JackHammerItem.DigMode digMode = JackHammerItem.getDigMode(player.getMainHandItem());
        boolean showHud = (Boolean)ConfigHelper.client().general.jackHammerHud.get();
        if (digMode.atLeast(JackHammerItem.DigMode.MODE_1X2) && showHud || timeDelta < 30L || player.isCrouching()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            float scaleFactor = Mth.clamp((float)((float)Minecraft.getInstance().getWindow().getGuiScale()), (float)2.0f, (float)3.0f);
            graphics.pose().pushPose();
            graphics.pose().translate((double)graphics.guiWidth() / 2.0, (double)graphics.guiHeight() / 2.0, 0.0);
            graphics.pose().scale(scaleFactor, scaleFactor, scaleFactor);
            graphics.pose().translate(8.0f, -8.0f, 0.0f);
            graphics.blit(digMode.getGuiIcon(), 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            graphics.pose().popPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

