/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.heat.HeatPipeBlockEntity;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HeatPipeBlock
extends AbstractCamouflageBlock
implements SimpleWaterloggedBlock,
PneumaticCraftEntityBlock {
    private static final VoxelShape CORE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape[] SIDES = new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0), Block.box((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0), Block.box((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)};
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[64];

    public HeatPipeBlock(BlockBehaviour.Properties props) {
        super(props);
        BlockState state = this.defaultBlockState();
        for (BooleanProperty prop : CONNECTION_PROPERTIES) {
            state = (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(state);
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add((Property[])CONNECTION_PROPERTIES);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        return HeatPipeBlock.recalculateState((LevelAccessor)ctx.getLevel(), ctx.getClickedPos(), state);
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return HeatPipeBlock.recalculateState(worldIn, currentPos, stateIn);
    }

    private static BlockState recalculateState(LevelAccessor worldIn, BlockPos currentPos, BlockState stateIn) {
        if (stateIn == null) {
            return null;
        }
        if (worldIn instanceof Level) {
            Level level = (Level)worldIn;
            for (Direction dir : DirectionUtil.VALUES) {
                BooleanProperty prop = AbstractPneumaticCraftBlock.connectionProperty(dir);
                BlockPos neighborPos = currentPos.relative(dir);
                boolean connected = level.getBlockState(neighborPos).getBlock() instanceof AbstractFurnaceBlock || HeatExchangerManager.getInstance().getLogic(level, neighborPos, dir.getOpposite(), HeatPipeBlockEntity.NO_AIR_OR_LIQUIDS).isPresent();
                stateIn = (BlockState)stateIn.setValue((Property)prop, (Comparable)Boolean.valueOf(connected));
            }
        }
        return stateIn;
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int i;
        int idx = 0;
        for (i = 0; i < 6; ++i) {
            if (!((Boolean)state.getValue((Property)CONNECTION_PROPERTIES[i])).booleanValue()) continue;
            idx = (byte)(idx | 1 << i);
        }
        if (SHAPE_CACHE[idx] == null) {
            HeatPipeBlock.SHAPE_CACHE[idx] = CORE;
            for (i = 0; i < 6; ++i) {
                if ((idx & 1 << i) == 0) continue;
                HeatPipeBlock.SHAPE_CACHE[idx] = Shapes.join((VoxelShape)SHAPE_CACHE[idx], (VoxelShape)SIDES[i], (BooleanOp)BooleanOp.OR);
            }
        }
        return SHAPE_CACHE[idx];
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new HeatPipeBlockEntity(pPos, pState);
    }
}

