/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammableControllerBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ProgrammableControllerBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    public ProgrammableControllerBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean reversePlacementRotation() {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter blockReader, BlockPos pos, Direction side) {
        return blockReader.getBlockEntity(pos, ModBlockEntityTypes.PROGRAMMABLE_CONTROLLER.get()).map(te -> te.getEmittingRedstone(side.getOpposite())).orElse(0);
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (entity instanceof Player) {
            PneumaticCraftUtils.getBlockEntityAt((BlockGetter)world, pos, ProgrammableControllerBlockEntity.class).ifPresent(te -> te.setOwner((Player)entity));
        }
        super.setPlacedBy(world, pos, state, entity, stack);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ProgrammableControllerBlockEntity(pPos, pState);
    }
}

