/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import it.unimi.dsi.fastutil.floats.FloatPredicate;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pressure.PressureHelper;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.capabilities.BasicAirHandler;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureBlock;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class MachineAirHandler
extends BasicAirHandler
implements IAirHandlerMachine,
IManoMeasurable {
    private final PressureTier tier;
    private int volumeUpgrades = 0;
    private final BitSet connectableFaces = new BitSet(6);
    private Direction leakDir = null;
    private Direction prevLeakDir = null;
    private int prevAir;
    private final Map<Direction, BlockCapabilityCache<IAirHandlerMachine, Direction>> neighbourAirHandlers = new EnumMap<Direction, BlockCapabilityCache<IAirHandlerMachine, Direction>>(Direction.class);
    private boolean safetyLeaking;
    private Direction safetyLeakDir;
    private FloatPredicate safetyPredicate;
    private int pendingAir;

    public MachineAirHandler(PressureTier tier, int volume) {
        super(volume);
        this.tier = tier;
    }

    @Override
    public int getVolume() {
        return PressureHelper.getUpgradedVolume(this.getBaseVolume(), this.volumeUpgrades);
    }

    @Override
    public float getDangerPressure() {
        return this.tier.getDangerPressure();
    }

    @Override
    public float getCriticalPressure() {
        return this.tier.getCriticalPressure();
    }

    @Override
    public void setPressure(float pressure) {
        this.addAir((int)(pressure * (float)this.getVolume()) - this.getAir());
    }

    @Override
    public void setVolumeUpgrades(int newVolumeUpgrades) {
        int newVolume = PressureHelper.getUpgradedVolume(this.getBaseVolume(), newVolumeUpgrades);
        if (newVolume < this.getVolume()) {
            int newAir = (int)((float)this.getAir() * (float)newVolume / (float)this.getVolume());
            this.addAir(newAir - this.getAir());
        }
        this.volumeUpgrades = newVolumeUpgrades;
    }

    @Override
    public void enableSafetyVenting(FloatPredicate pressureCheck, Direction dir) {
        this.safetyPredicate = pressureCheck;
        this.safetyLeakDir = dir;
    }

    @Override
    public void disableSafetyVenting() {
        this.safetyPredicate = null;
        this.safetyLeakDir = null;
    }

    @Override
    public void setConnectableFaces(Collection<Direction> sides) {
        this.connectableFaces.clear();
        sides.forEach(side -> this.connectableFaces.set(side.get3DDataValue()));
    }

    @Override
    public void tick(BlockEntity ownerTE) {
        Level world = Objects.requireNonNull(ownerTE.getLevel());
        Direction actualLeakDir = this.leakDir;
        if (!world.isClientSide) {
            if (this.pendingAir != 0) {
                this.addAir(this.pendingAir);
                this.pendingAir = 0;
                if (this.getPressure() > this.getDangerPressure()) {
                    this.setPressure(this.getDangerPressure() - 0.1f);
                }
            }
            this.disperseAir(ownerTE);
            BlockPos pos = ownerTE.getBlockPos();
            if (this.safetyLeakDir != null) {
                float pressure = this.getPressure();
                if (!this.safetyLeaking && this.safetyPredicate.test(pressure)) {
                    this.safetyLeaking = true;
                } else if (this.safetyLeaking && !this.safetyPredicate.test(pressure + 0.2f)) {
                    this.safetyLeaking = false;
                }
                if (pressure >= this.getCriticalPressure()) {
                    int wanted = (int)(this.getCriticalPressure() * (float)this.getVolume());
                    this.addAir(wanted - this.getAir());
                }
            } else if (Objects.requireNonNull(world.getServer()).getTickCount() > 20) {
                this.doOverpressureChecks(ownerTE, world, pos);
            }
            Direction direction = actualLeakDir = this.safetyLeaking ? this.safetyLeakDir : this.leakDir;
            if (this.prevLeakDir != actualLeakDir || actualLeakDir != null && (world.getGameTime() & 0x1FL) == 0L) {
                NetworkHandler.sendToAllTracking((CustomPacketPayload)PacketUpdatePressureBlock.create(ownerTE.getBlockPos(), this.anyConnectableFace(), actualLeakDir, this.getAir()), ownerTE);
            }
            this.prevAir = this.getAir();
            this.prevLeakDir = actualLeakDir;
        }
        if (actualLeakDir != null && this.getAir() != 0) {
            this.handleAirLeak(ownerTE, actualLeakDir);
        }
    }

    private Direction anyConnectableFace() {
        for (Direction d : DirectionUtil.VALUES) {
            if (!this.connectableFaces.get(d.get3DDataValue())) continue;
            return d;
        }
        return null;
    }

    private void doOverpressureChecks(BlockEntity ownerTE, Level world, BlockPos pos) {
        float p = this.getPressure();
        if (this.getAir() > this.prevAir && p > this.getDangerPressure()) {
            float range = this.getCriticalPressure() - this.getDangerPressure();
            float delta = p - this.getDangerPressure();
            float rnd = world.random.nextFloat() * range;
            if (rnd < delta / 125.0f || p > this.getCriticalPressure()) {
                world.explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1.0f, Level.ExplosionInteraction.BLOCK);
                world.destroyBlock(pos, false);
            } else if (rnd < delta / 25.0f) {
                world.playSound(null, ownerTE.getBlockPos(), (SoundEvent)ModSounds.CREAK.get(), SoundSource.BLOCKS, 0.7f, 0.6f + world.random.nextFloat() * 0.8f);
            }
        }
    }

    private void handleAirLeak(BlockEntity ownerTE, Direction actualLeakDir) {
        Level world = Objects.requireNonNull(ownerTE.getLevel());
        BlockPos pos = ownerTE.getBlockPos();
        float pressure = this.getPressure();
        if (!world.isClientSide) {
            if ((world.getGameTime() & 0xFL) == 0L && this.checkForCrossChunkLeak(ownerTE, pos, actualLeakDir)) {
                this.setSideLeaking(null);
                return;
            }
            if (this.getAir() > 0) {
                int leakedAmount = (int)(pressure * 40.0f) + 20;
                if (leakedAmount > this.getAir()) {
                    leakedAmount = this.getAir();
                }
                this.onAirDispersion(ownerTE, actualLeakDir, -leakedAmount);
                this.addAir(-leakedAmount);
            } else if (this.getAir() < 0) {
                int leakedAmount = -((int)(pressure * 40.0f)) + 20;
                if (this.getAir() > leakedAmount) {
                    leakedAmount = -this.getAir();
                }
                this.onAirDispersion(ownerTE, actualLeakDir, leakedAmount);
                this.addAir(leakedAmount);
            }
        } else {
            double mx = actualLeakDir.getStepX();
            double my = actualLeakDir.getStepY();
            double mz = actualLeakDir.getStepZ();
            double speed = this.getPressure() * 0.1f;
            if (this.getAir() > 0) {
                if (pressure > 1.0f || pressure > 0.5f && world.random.nextBoolean() || world.random.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)AirParticleData.DENSE, (double)pos.getX() + 0.5 + mx * 0.6, (double)pos.getY() + 0.5 + my * 0.6, (double)pos.getZ() + 0.5 + mz * 0.6, mx * speed, my * speed, mz * speed);
                }
            } else if (this.getAir() < 0 && world.random.nextBoolean()) {
                world.addParticle((ParticleOptions)AirParticleData.DENSE, (double)pos.getX() + 0.5 + mx, (double)pos.getY() + 0.5 + my, (double)pos.getZ() + 0.5 + mz, mx * speed, my * speed, mz * speed);
            }
            MovingSounds.playMovingSound(MovingSounds.Sound.AIR_LEAK, ownerTE.getBlockPos(), this.anyConnectableFace());
        }
    }

    private boolean checkForCrossChunkLeak(BlockEntity ownerTE, BlockPos pos, Direction actualLeakDir) {
        BlockEntity neighbourBE;
        BlockPos pos2 = pos.relative(actualLeakDir);
        if ((pos.getX() >> 4 != pos2.getX() >> 4 || pos.getZ() >> 4 != pos2.getZ() >> 4) && ownerTE.getLevel() != null && ownerTE.getLevel().hasChunk(pos2.getX() >> 4, pos2.getZ() >> 4) && (neighbourBE = ownerTE.getLevel().getBlockEntity(pos2)) != null && ownerTE instanceof AbstractAirHandlingBlockEntity) {
            AbstractAirHandlingBlockEntity airBE = (AbstractAirHandlingBlockEntity)ownerTE;
            IAirHandlerMachine cap = (IAirHandlerMachine)ownerTE.getLevel().getCapability(PNCCapabilities.AIR_HANDLER_MACHINE, pos2, neighbourBE.getBlockState(), neighbourBE, (Object)actualLeakDir.getOpposite());
            if (cap != null) {
                airBE.onNeighborBlockUpdate(pos2);
                return true;
            }
        }
        return false;
    }

    @Override
    public void setSideLeaking(@Nullable Direction dir) {
        this.leakDir = dir;
    }

    @Override
    @Nullable
    public Direction getSideLeaking() {
        return this.leakDir;
    }

    private Optional<IAirHandlerMachine> getNeighbourAirHandler(BlockEntity ownerTE, Direction dir) {
        if (!this.connectableFaces.get(dir.get3DDataValue())) {
            return Optional.empty();
        }
        Level level = ownerTE.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.neighbourAirHandlers.get(dir) == null) {
                this.neighbourAirHandlers.put(dir, (BlockCapabilityCache<IAirHandlerMachine, Direction>)BlockCapabilityCache.create(PNCCapabilities.AIR_HANDLER_MACHINE, (ServerLevel)level2, (BlockPos)ownerTE.getBlockPos().relative(dir), (Object)dir.getOpposite()));
            }
            return Optional.ofNullable((IAirHandlerMachine)this.neighbourAirHandlers.get(dir).getCapability());
        }
        BlockEntity be = ownerTE.getLevel().getBlockEntity(ownerTE.getBlockPos().relative(dir));
        return be == null ? Optional.empty() : PNCCapabilities.getAirHandler(be, dir.getOpposite());
    }

    private void disperseAir(BlockEntity ownerTE) {
        List<IAirHandlerMachine.Connection> neighbours = this.getConnectedAirHandlers(ownerTE, true);
        int totalVolume = this.getVolume();
        int totalAir = this.getAir();
        for (IAirHandlerMachine.Connection neighbour : neighbours) {
            totalVolume += neighbour.getAirHandler().getVolume();
            totalAir += neighbour.getAirHandler().getAir();
        }
        for (IAirHandlerMachine.Connection neighbour : neighbours) {
            int totalMachineAir = (int)((long)totalAir * (long)neighbour.getAirHandler().getVolume() / (long)totalVolume);
            neighbour.setMaxDispersion(this.getMaxDispersion(ownerTE, neighbour.getDirection()));
            neighbour.setAirToDisperse(Math.max(0, totalMachineAir - neighbour.getAirHandler().getAir()));
        }
        for (IAirHandlerMachine.Connection neighbour : neighbours) {
            int air = Math.min(neighbour.getMaxDispersion(), neighbour.getDispersedAir());
            if (air == 0) continue;
            this.onAirDispersion(ownerTE, neighbour.getDirection(), air);
            neighbour.getAirHandler().addAir(air);
            this.addAir(-air);
        }
    }

    private List<IAirHandlerMachine.Connection> getConnectedAirHandlers(BlockEntity ownerTE, boolean onlyLowerPressure) {
        ArrayList<IAirHandlerMachine.Connection> neighbours = new ArrayList<IAirHandlerMachine.Connection>();
        for (Direction dir : DirectionUtil.VALUES) {
            if (!this.connectableFaces.get(dir.get3DDataValue())) continue;
            this.getNeighbourAirHandler(ownerTE, dir).ifPresent(h -> {
                if (!onlyLowerPressure || h.getPressure() < this.getPressure()) {
                    neighbours.add(new ConnectedAirHandler(dir, (IAirHandlerMachine)h));
                }
            });
        }
        neighbours.addAll(this.addExtraConnectedHandlers(ownerTE).stream().filter(h -> !onlyLowerPressure || h.getPressure() < this.getPressure()).map(ConnectedAirHandler::new).toList());
        return neighbours;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.leakDir != null) {
            nbt.putByte("Leaking", (byte)this.leakDir.get3DDataValue());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.leakDir = nbt.contains("Leaking") ? Direction.from3DDataValue((int)nbt.getByte("Leaking")) : null;
    }

    @Override
    public void addPendingAir(int pendingAir) {
        this.pendingAir = pendingAir;
    }

    @Override
    public List<IAirHandlerMachine.Connection> getConnectedAirHandlers(BlockEntity ownerTE) {
        return this.getConnectedAirHandlers(ownerTE, false);
    }

    private List<IAirHandlerMachine> addExtraConnectedHandlers(BlockEntity ownerTE) {
        List<IAirHandlerMachine> list;
        if (ownerTE instanceof IAirListener) {
            IAirListener l = (IAirListener)ownerTE;
            list = l.addConnectedPneumatics(new ArrayList<IAirHandlerMachine>());
        } else {
            list = List.of();
        }
        return list;
    }

    private void onAirDispersion(BlockEntity ownerTE, Direction dir, int airDispersed) {
        if (ownerTE instanceof IAirListener) {
            IAirListener l = (IAirListener)ownerTE;
            l.onAirDispersion(this, dir, airDispersed);
        }
    }

    private int getMaxDispersion(BlockEntity ownerTE, Direction dir) {
        int n;
        if (ownerTE instanceof IAirListener) {
            IAirListener l = (IAirListener)ownerTE;
            n = l.getMaxDispersion(this, dir);
        } else {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    @Override
    public void printManometerMessage(Player player, List<Component> curInfo) {
        curInfo.add((Component)Component.translatable((String)"pneumaticcraft.gui.tooltip.pressure", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(this.getPressure(), 1)}));
    }

    private static class ConnectedAirHandler
    implements IAirHandlerMachine.Connection {
        @Nullable
        final Direction direction;
        final IAirHandlerMachine airHandler;
        int maxDispersion;
        int toDisperse;

        ConnectedAirHandler(@Nullable Direction direction, IAirHandlerMachine airHandler) {
            this.direction = direction;
            this.airHandler = airHandler;
        }

        ConnectedAirHandler(IAirHandlerMachine airHandler) {
            this(null, airHandler);
        }

        @Override
        @Nullable
        public Direction getDirection() {
            return this.direction;
        }

        @Override
        public int getMaxDispersion() {
            return this.maxDispersion;
        }

        @Override
        public void setMaxDispersion(int maxDispersion) {
            this.maxDispersion = maxDispersion;
        }

        @Override
        public int getDispersedAir() {
            return this.toDisperse;
        }

        @Override
        public void setAirToDisperse(int toDisperse) {
            this.toDisperse = toDisperse;
        }

        @Override
        public IAirHandlerMachine getAirHandler() {
            return this.airHandler;
        }
    }
}

