/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;

public class ProgWidgetUtils {
    private static final int SNAP_MARGIN = 4;
    private static final int HALF_HEIGHT = 11;

    public static List<IProgWidget> getWidgetsFromNBT(HolderLookup.Provider provider, Tag tag) {
        return ProgWidgetUtils.filterAvailable(ProgWidget.LIST_CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(message -> Log.warning("deserialization error: {}", message)).orElse(List.of()));
    }

    public static List<IProgWidget> getWidgetsFromJson(HolderLookup.Provider provider, JsonElement json) {
        return ProgWidgetUtils.filterAvailable(ProgWidget.Versioned.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)json).resultOrPartial(message -> Log.warning("deserialization error: {}", message)).map(ProgWidget.Versioned::widgets).orElse(List.of()));
    }

    private static List<IProgWidget> filterAvailable(List<IProgWidget> list) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (IProgWidget w : list) {
            if (w.isAvailable()) {
                b.add((Object)w);
                continue;
            }
            Log.warning("ignoring unavailable widget type: {}" + String.valueOf(w.getType()), new Object[0]);
        }
        return b.build();
    }

    public static Tag putWidgetsToNBT(HolderLookup.Provider provider, List<IProgWidget> widgets) {
        return (Tag)ProgWidget.LIST_CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), widgets).getOrThrow();
    }

    public static JsonElement putWidgetsToJson(HolderLookup.Provider provider, List<IProgWidget> widgets) {
        return (JsonElement)ProgWidget.Versioned.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)new ProgWidget.Versioned(3, widgets)).getOrThrow();
    }

    public static void updatePuzzleConnections(List<IProgWidget> progWidgets) {
        IProgWidget widget;
        List<ProgWidgetType<?>> parameters;
        HashMap<ProgWidget.PositionFields, IProgWidget> byPosition = new HashMap<ProgWidget.PositionFields, IProgWidget>();
        for (IProgWidget widget2 : progWidgets) {
            widget2.setParent(null);
            parameters = widget2.getParameters();
            for (int paramIdx = 0; paramIdx < parameters.size() * 2; ++paramIdx) {
                widget2.setParameter(paramIdx, null);
            }
            if (widget2.hasStepOutput()) {
                widget2.setOutputWidget(null);
            }
            byPosition.put(new ProgWidget.PositionFields(widget2.getX(), widget2.getY()), widget2);
        }
        for (IProgWidget checkedWidget : progWidgets) {
            IProgWidget widget3;
            parameters = checkedWidget.getParameters();
            for (int paramIdx = 0; paramIdx < parameters.size(); ++paramIdx) {
                widget = (IProgWidget)byPosition.get(ProgWidget.PositionFields.rightParam(checkedWidget, paramIdx));
                if (widget == null || !checkedWidget.canSetParameter(paramIdx) || parameters.get(paramIdx) != widget.returnType()) continue;
                checkedWidget.setParameter(paramIdx, widget);
                widget.setParent(checkedWidget);
            }
            if (!checkedWidget.hasStepOutput() || (widget3 = (IProgWidget)byPosition.get(ProgWidget.PositionFields.below(checkedWidget))) == null || !widget3.hasStepInput()) continue;
            checkedWidget.setOutputWidget(widget3);
        }
        for (IProgWidget checkedWidget : progWidgets) {
            if (checkedWidget.returnType() != null) continue;
            parameters = checkedWidget.getParameters();
            for (int paramIdx = 0; paramIdx < parameters.size(); ++paramIdx) {
                if (!checkedWidget.canSetParameter(paramIdx) || (widget = (IProgWidget)byPosition.get(ProgWidget.PositionFields.leftParam(checkedWidget, paramIdx))) == null || parameters.get(paramIdx) != widget.returnType()) continue;
                IProgWidget root = widget;
                while (root.getParent() != null) {
                    root = root.getParent();
                }
                checkedWidget.setParameter(paramIdx + parameters.size(), root);
            }
        }
    }

    public static void snapWidgetIntoProgram(IProgWidget placingWidget, List<IProgWidget> allWidgets) {
        List<ProgWidgetType<?>> parameters;
        ProgWidgetType<?> returnValue = placingWidget.returnType();
        if (returnValue != null) {
            for (IProgWidget widget : allWidgets) {
                if (widget == placingWidget || Math.abs(widget.getX() + widget.getWidth() / 2 - placingWidget.getX()) > 4) continue;
                List<ProgWidgetType<?>> parameters2 = widget.getParameters();
                for (int i = 0; i < parameters2.size(); ++i) {
                    if (!widget.canSetParameter(i) || parameters2.get(i) != returnValue || Math.abs(widget.getY() + i * 11 - placingWidget.getY()) > 4) continue;
                    ProgWidgetUtils.positionConnectedWidgets(placingWidget, widget.getX() + widget.getWidth() / 2, widget.getY() + i * 11);
                    return;
                }
            }
        }
        if (!(parameters = placingWidget.getParameters()).isEmpty()) {
            for (IProgWidget widget : allWidgets) {
                IProgWidget outerPiece = placingWidget;
                if (outerPiece.returnType() != null) {
                    while (outerPiece.getConnectedParameters()[0] != null) {
                        outerPiece = outerPiece.getConnectedParameters()[0];
                    }
                }
                if (widget == placingWidget || Math.abs(outerPiece.getX() + outerPiece.getWidth() / 2 - widget.getX()) > 4) continue;
                if (widget.returnType() != null) {
                    for (int i = 0; i < parameters.size(); ++i) {
                        if (!placingWidget.canSetParameter(i) || parameters.get(i) != widget.returnType() || Math.abs(placingWidget.getY() + i * 11 - widget.getY()) > 4) continue;
                        ProgWidgetUtils.positionConnectedWidgets(placingWidget, widget.getX() - placingWidget.getWidth() / 2 - (outerPiece.getX() - placingWidget.getX()), widget.getY() - i * 11);
                    }
                    continue;
                }
                List<ProgWidgetType<?>> params = widget.getParameters();
                for (int paramIdx = 0; paramIdx < params.size(); ++paramIdx) {
                    if (!widget.canSetParameter(paramIdx + parameters.size()) || params.get(paramIdx) != parameters.getFirst() || Math.abs(widget.getY() + paramIdx * 11 - placingWidget.getY()) > 4) continue;
                    ProgWidgetUtils.positionConnectedWidgets(placingWidget, widget.getX() - placingWidget.getWidth() / 2 - (outerPiece.getX() - placingWidget.getX()), widget.getY() + paramIdx * 11);
                }
            }
        }
        if (placingWidget.hasStepInput()) {
            for (IProgWidget widget : allWidgets) {
                if (!widget.hasStepOutput() || Math.abs(widget.getX() - placingWidget.getX()) > 4 || Math.abs(widget.getY() + widget.getHeight() / 2 - placingWidget.getY()) > 4) continue;
                ProgWidgetUtils.positionConnectedWidgets(placingWidget, widget.getX(), widget.getY() + widget.getHeight() / 2);
            }
        }
        if (placingWidget.hasStepOutput()) {
            for (IProgWidget widget : allWidgets) {
                if (!widget.hasStepInput() || Math.abs(widget.getX() - placingWidget.getX()) > 4 || Math.abs(widget.getY() - placingWidget.getY() - placingWidget.getHeight() / 2) > 4) continue;
                ProgWidgetUtils.positionConnectedWidgets(placingWidget, widget.getX(), widget.getY() - placingWidget.getHeight() / 2);
            }
        }
    }

    public static void positionConnectedWidgets(IProgWidget widget, int x, int y) {
        IProgWidget outputWidget;
        widget.setPosition(x, y);
        IProgWidget[] connectingWidgets = widget.getConnectedParameters();
        if (connectingWidgets != null) {
            for (int i = 0; i < connectingWidgets.length; ++i) {
                if (connectingWidgets[i] == null) continue;
                if (i < connectingWidgets.length / 2) {
                    ProgWidgetUtils.positionConnectedWidgets(connectingWidgets[i], x + widget.getWidth() / 2, y + i * 11);
                    continue;
                }
                int totalWidth = 0;
                IProgWidget branch = connectingWidgets[i];
                while (branch != null) {
                    totalWidth += branch.getWidth() / 2;
                    branch = branch.getConnectedParameters()[0];
                }
                ProgWidgetUtils.positionConnectedWidgets(connectingWidgets[i], x - totalWidth, y + (i - connectingWidgets.length / 2) * 11);
            }
        }
        if ((outputWidget = widget.getOutputWidget()) != null) {
            ProgWidgetUtils.positionConnectedWidgets(outputWidget, x, y + widget.getHeight() / 2);
        }
    }
}

