/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class ProgWidgetLiquidFilter
extends ProgWidget {
    public static final MapCodec<ProgWidgetLiquidFilter> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetLiquidFilter.baseParts(builder).and((App)FluidStack.OPTIONAL_CODEC.optionalFieldOf("fluid", (Object)FluidStack.EMPTY).forGetter(ProgWidgetLiquidFilter::getFluidStack)).apply((Applicative)builder, ProgWidgetLiquidFilter::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetLiquidFilter> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, ProgWidgetLiquidFilter::getFluidStack, ProgWidgetLiquidFilter::new);
    private FluidStack fluidStack;

    public ProgWidgetLiquidFilter(ProgWidget.PositionFields pos, FluidStack fluidStack) {
        super(pos);
        this.fluidStack = fluidStack;
    }

    public ProgWidgetLiquidFilter() {
        this(ProgWidget.PositionFields.DEFAULT, FluidStack.EMPTY);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetLiquidFilter(this.getPosition(), this.fluidStack.copy());
    }

    public static ProgWidgetLiquidFilter withFilter(Fluid fluid) {
        return ProgWidgetLiquidFilter.withFilter(new FluidStack(fluid, 1000));
    }

    public static ProgWidgetLiquidFilter withFilter(FluidStack fluid) {
        ProgWidgetLiquidFilter f = new ProgWidgetLiquidFilter();
        f.setFluidStack(fluid);
        return f;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.fluidStack.isEmpty()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.liquidFilter.error.noLiquid", new Object[0]));
        }
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return ModProgWidgetTypes.LIQUID_FILTER.get();
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.LIQUID_FILTER.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_LIQUID_FILTER;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.LIQUID_FILTER.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.fluidStack != null) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.fluid", new Object[0]).withStyle(ChatFormatting.AQUA).append(this.asTextComponent()));
        }
    }

    private boolean isLiquidValid(Fluid fluid) {
        return this.fluidStack.isEmpty() || fluid == this.fluidStack.getFluid();
    }

    public static boolean isLiquidValid(Fluid fluid, IProgWidget mainWidget, int filterIndex) {
        ProgWidgetLiquidFilter widget = (ProgWidgetLiquidFilter)mainWidget.getConnectedParameters()[mainWidget.getParameters().size() + filterIndex];
        while (widget != null) {
            if (!widget.isLiquidValid(fluid)) {
                return false;
            }
            widget = (ProgWidgetLiquidFilter)widget.getConnectedParameters()[0];
        }
        widget = (ProgWidgetLiquidFilter)mainWidget.getConnectedParameters()[filterIndex];
        if (widget == null) {
            return true;
        }
        while (widget != null) {
            if (widget.isLiquidValid(fluid)) {
                return true;
            }
            widget = (ProgWidgetLiquidFilter)widget.getConnectedParameters()[0];
        }
        return false;
    }

    public static boolean isLiquidValid(Fluid fluid, List<ProgWidgetLiquidFilter> whitelist, List<ProgWidgetLiquidFilter> blacklist) {
        for (ProgWidgetLiquidFilter filter2 : blacklist) {
            if (filter2.isLiquidValid(fluid)) continue;
            return false;
        }
        return whitelist.isEmpty() || whitelist.stream().anyMatch(filter -> filter.isLiquidValid(fluid));
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return Collections.singletonList(this.asTextComponent());
    }

    private Component asTextComponent() {
        return !this.fluidStack.isEmpty() ? this.fluidStack.getHoverName() : PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.liquidFilter.noFluid", new Object[0]);
    }

    public void setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.RED;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgWidgetLiquidFilter that = (ProgWidgetLiquidFilter)o;
        return this.baseEquals(that) && Objects.equals(this.fluidStack, that.fluidStack);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.fluidStack);
    }
}

