/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetText
extends ProgWidget {
    public static final MapCodec<ProgWidgetText> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetText.baseParts(builder).and((App)Codec.STRING.fieldOf("string").forGetter(ProgWidgetText::getString)).apply((Applicative)builder, ProgWidgetText::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetText> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)ByteBufCodecs.STRING_UTF8, ProgWidgetText::getString, ProgWidgetText::new);
    protected String string = "";

    public ProgWidgetText() {
        super(ProgWidget.PositionFields.DEFAULT);
    }

    protected ProgWidgetText(ProgWidget.PositionFields positionFields, String string) {
        super(positionFields);
        this.string = string;
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetText(this.getPosition(), this.string);
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public static ProgWidgetText withText(String string) {
        ProgWidgetText widget = new ProgWidgetText();
        widget.string = string;
        return widget;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.TEXT.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.addToTooltip()) {
            curTooltip.addAll(this.getExtraStringInfo());
        }
    }

    protected boolean addToTooltip() {
        return true;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return Collections.singletonList(this.varAsTextComponent(this.string));
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return ModProgWidgetTypes.TEXT.get();
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.TEXT.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_TEXT;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.LIGHT_BLUE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetText that = (ProgWidgetText)o;
        return this.baseEquals(that) && Objects.equals(this.string, that.string);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.string);
    }
}

