/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketJetBootsActivate(boolean state) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketJetBootsActivate> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("jetboots_activate"));
    public static final StreamCodec<FriendlyByteBuf, PacketJetBootsActivate> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, PacketJetBootsActivate::state, PacketJetBootsActivate::new);

    public CustomPacketPayload.Type<PacketJetBootsActivate> type() {
        return TYPE;
    }

    public static void handle(PacketJetBootsActivate message, IPayloadContext ctx) {
        Player player = ctx.player();
        if (PneumaticArmorItem.isPneumaticArmorPiece(player, EquipmentSlot.FEET)) {
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
            if (handler.getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.JET_BOOTS.get()) > 0 && (!message.state() || jbState.isEnabled())) {
                CommonUpgradeHandlers.jetBootsHandler.setJetBootsActive(handler, message.state());
            }
        }
    }
}

