/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.HashSet;
import java.util.Set;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketShowArea(BlockPos pos, Set<BlockPos> area) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketShowArea> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("show_area"));
    public static final StreamCodec<FriendlyByteBuf, PacketShowArea> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketShowArea::pos, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.collection(HashSet::new)), PacketShowArea::area, PacketShowArea::new);

    public static PacketShowArea forPos(BlockPos pos) {
        return new PacketShowArea(pos, Set.of());
    }

    public static PacketShowArea forArea(BlockPos pos, Set<BlockPos> area) {
        return new PacketShowArea(pos, area);
    }

    public CustomPacketPayload.Type<PacketShowArea> type() {
        return TYPE;
    }

    public static void handle(PacketShowArea message, IPayloadContext ctx) {
        AreaRenderManager.getInstance().showArea(message.area(), -1878982657, ClientUtils.getBlockEntity(message.pos()));
    }
}

