/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.RefineryRecipe;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.apache.commons.lang3.Validate;

public class RefineryRecipeImpl
extends RefineryRecipe {
    public final SizedFluidIngredient input;
    public final List<FluidStack> outputs;
    private final TemperatureRange operatingTemp;

    public RefineryRecipeImpl(SizedFluidIngredient input, TemperatureRange operatingTemp, List<FluidStack> outputs) {
        this.operatingTemp = operatingTemp;
        Validate.isTrue((outputs.size() >= 2 && outputs.size() <= 4 ? 1 : 0) != 0, (String)"Recipe must have between 2 and 4 (inclusive) outputs", (Object[])new Object[0]);
        this.input = input;
        this.outputs = ImmutableList.copyOf(outputs);
    }

    @Override
    public SizedFluidIngredient getInput() {
        return this.input;
    }

    @Override
    public List<FluidStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public TemperatureRange getOperatingTemp() {
        return this.operatingTemp;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.REFINERY.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.REFINERY.get();
    }

    public String getGroup() {
        return "pneumaticcraft:refinery";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.REFINERY.get());
    }

    public static class Serializer<T extends RefineryRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SizedFluidIngredient.FLAT_CODEC.fieldOf("input").forGetter(RefineryRecipe::getInput), (App)TemperatureRange.CODEC.optionalFieldOf("temperature", (Object)TemperatureRange.min(373)).forGetter(RefineryRecipe::getOperatingTemp), (App)FluidStack.CODEC.listOf(2, 4).fieldOf("outputs").forGetter(RefineryRecipe::getOutputs)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)SizedFluidIngredient.STREAM_CODEC, RefineryRecipe::getInput, TemperatureRange.STREAM_CODEC, RefineryRecipe::getOperatingTemp, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), RefineryRecipe::getOutputs, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends RefineryRecipe> {
        public T create(SizedFluidIngredient var1, TemperatureRange var2, List<FluidStack> var3);
    }
}

