/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ProgWidgetUtils;

public class DroneProgramBuilder {
    private final List<DroneInstruction> instructions = new ArrayList<DroneInstruction>();

    public void add(IProgWidget mainInstruction, IProgWidget ... whitelist) {
        this.instructions.add(new DroneInstruction(mainInstruction, Arrays.asList(whitelist)));
    }

    public List<IProgWidget> build() {
        ArrayList<IProgWidget> allWidgets = new ArrayList<IProgWidget>();
        int curY = 0;
        for (DroneInstruction instruction : this.instructions) {
            instruction.mainInstruction.setPosition(0, curY);
            if (!instruction.whitelist.isEmpty()) {
                for (int paramIdx = 0; paramIdx < instruction.mainInstruction.getParameters().size(); ++paramIdx) {
                    ProgWidgetType<?> type = instruction.mainInstruction.getParameters().get(paramIdx);
                    List<IProgWidget> whitelist = instruction.whitelist.stream().filter(w -> type == w.getType()).toList();
                    int curX = instruction.mainInstruction.getWidth() / 2;
                    for (IProgWidget whitelistItem : whitelist) {
                        whitelistItem.setPosition(curX, curY + paramIdx * 22 / 2);
                        curX += whitelistItem.getWidth() / 2;
                    }
                }
            }
            curY += instruction.mainInstruction.getHeight() / 2;
            instruction.addToWidgets(allWidgets);
        }
        ProgWidgetUtils.updatePuzzleConnections(allWidgets);
        return allWidgets;
    }

    private record DroneInstruction(IProgWidget mainInstruction, List<IProgWidget> whitelist) {
        void addToWidgets(List<IProgWidget> widgets) {
            widgets.add(this.mainInstruction);
            widgets.addAll(this.whitelist);
        }
    }
}

