/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.playerfilter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.IPlayerFilter;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public record PlayerFilter(Op op, List<IPlayerMatcher> matchers) implements IPlayerFilter
{
    public static final Codec<PlayerFilter> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StringRepresentable.fromEnum(Op::values).fieldOf("op").forGetter(PlayerFilter::op), (App)IPlayerMatcher.CODEC.listOf().fieldOf("matchers").forGetter(PlayerFilter::matchers)).apply((Applicative)inst, PlayerFilter::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayerFilter> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(Op.class), PlayerFilter::op, (StreamCodec)IPlayerMatcher.STREAM_CODEC.apply(ByteBufCodecs.list()), PlayerFilter::matchers, PlayerFilter::new);
    public static final PlayerFilter YES = new PlayerFilter(Op.YES, List.of());
    public static final PlayerFilter NO = new PlayerFilter(Op.NO, List.of());

    public static PlayerFilter fromNetwork(RegistryFriendlyByteBuf buffer) {
        return (PlayerFilter)STREAM_CODEC.decode((Object)buffer);
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        STREAM_CODEC.encode((Object)buffer, (Object)this);
    }

    @Override
    public boolean isReal() {
        return this.op.isReal();
    }

    @Override
    public boolean matchAll() {
        return this.op == Op.AND;
    }

    @Override
    public boolean test(Player player) {
        return switch (this.op.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> false;
            case 3 -> this.matchers.stream().anyMatch(matcher -> matcher.test(player));
            case 2 -> this.matchers.stream().allMatch(matcher -> matcher.test(player));
        };
    }

    @Override
    public void getDescription(Player player, List<Component> tooltip) {
        if (this.isReal()) {
            this.matchers.forEach(matcher -> matcher.addDescription(player, tooltip));
        }
    }

    @Override
    public String toString() {
        String delimiter = " " + this.op.toString() + " ";
        return "[" + this.matchers.stream().map(Object::toString).collect(Collectors.joining(delimiter)) + "]";
    }

    public static enum Op implements StringRepresentable
    {
        YES("yes"),
        NO("no"),
        AND("and"),
        OR("or");

        private final String name;

        private Op(String name) {
            this.name = name;
        }

        public boolean isReal() {
            return this == AND || this == OR;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

