/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.solar;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.block.Tier;
import owmii.powah.block.solar.SolarTile;
import owmii.powah.config.v2.types.GeneratorConfig;
import owmii.powah.inventory.SolarContainer;
import owmii.powah.lib.block.AbstractGeneratorBlock;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.logistics.inventory.AbstractContainer;

public class SolarBlock
extends AbstractGeneratorBlock<SolarBlock>
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = SolarBlock.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;

    public SolarBlock(BlockBehaviour.Properties properties, Tier variant) {
        super(properties, variant);
        this.setStateProps(state -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable ResourceKey<CreativeModeTab> group) {
        return super.getBlockItem(properties.stacksTo(1), (ResourceKey)group);
    }

    @Override
    public GeneratorConfig getConfig() {
        return Powah.config().generators.solar_panels;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SolarTile(pos, state, (Tier)this.variant);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    @Nullable
    public AbstractContainer getContainer(int id, Inventory inventory, AbstractTileEntity te, BlockHitResult result) {
        if (te instanceof SolarTile) {
            return new SolarContainer(id, inventory, (SolarTile)te);
        }
        return null;
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return this.createState(world, currentPos);
    }

    @Override
    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.createState((LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    private BlockState createState(LevelAccessor world, BlockPos pos) {
        BlockState state = this.defaultBlockState();
        boolean north = this.canAttach(state, world, pos, Direction.NORTH);
        boolean south = this.canAttach(state, world, pos, Direction.SOUTH);
        boolean west = this.canAttach(state, world, pos, Direction.WEST);
        boolean east = this.canAttach(state, world, pos, Direction.EAST);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(!north))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(!south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(!west))).setValue((Property)EAST, (Comparable)Boolean.valueOf(!east))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER));
    }

    public boolean canAttach(BlockState state, LevelAccessor world, BlockPos pos, Direction direction) {
        return world.getBlockState(pos.relative(direction)).getBlock() == this;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST});
        super.createBlockStateDefinition(builder);
    }

    public List<Direction> getConnectedSides(BlockState state) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        if (!((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            list.add(Direction.NORTH);
        }
        if (!((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            list.add(Direction.SOUTH);
        }
        if (!((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            list.add(Direction.WEST);
        }
        if (!((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            list.add(Direction.EAST);
        }
        return list;
    }
}

