/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.immersiveui.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.joml.Matrix4f;

public class RenderUtils {
    public static final ResourceLocation ALT_FONT = ResourceLocation.withDefaultNamespace((String)"alt");
    public static final ResourceLocation ILLAGER_ALT_FONT = ResourceLocation.withDefaultNamespace((String)"illageralt");

    public static void renderTextureFromCenter(PoseStack matrix, float centerX, float centerY, float width, float height, float scale) {
        RenderUtils.renderTextureFromCenter(matrix, centerX, centerY, 0.0f, 0.0f, width, height, width, height, scale);
    }

    public static void renderTextureFromCenter(PoseStack matrix, float centerX, float centerY, float texOffX, float texOffY, float texWidth, float texHeight, float width, float height, float scale) {
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        matrix.pushPose();
        matrix.translate(centerX, centerY, 0.0f);
        matrix.scale(scale, scale, scale);
        Matrix4f m = matrix.last().pose();
        float u1 = texOffX / texWidth;
        float u2 = (texOffX + width) / texWidth;
        float v1 = texOffY / texHeight;
        float v2 = (texOffY + height) / texHeight;
        float w2 = width / 2.0f;
        float h2 = height / 2.0f;
        builder.addVertex(m, -w2, h2, 0.0f).setUv(u1, v2);
        builder.addVertex(m, w2, h2, 0.0f).setUv(u2, v2);
        builder.addVertex(m, w2, -h2, 0.0f).setUv(u2, v1);
        builder.addVertex(m, -w2, -h2, 0.0f).setUv(u1, v1);
        matrix.popPose();
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static int lerpColor(int colorStart, int colorEnd, float t) {
        if (t < 0.0f) {
            t = 0.0f;
        }
        if (t > 1.0f) {
            t = 1.0f;
        }
        int aStart = colorStart >> 24 & 0xFF;
        int rStart = colorStart >> 16 & 0xFF;
        int gStart = colorStart >> 8 & 0xFF;
        int bStart = colorStart & 0xFF;
        int aEnd = colorEnd >> 24 & 0xFF;
        int rEnd = colorEnd >> 16 & 0xFF;
        int gEnd = colorEnd >> 8 & 0xFF;
        int bEnd = colorEnd & 0xFF;
        int a = (int)((float)aStart + t * (float)(aEnd - aStart));
        int r = (int)((float)rStart + t * (float)(rEnd - rStart));
        int g = (int)((float)gStart + t * (float)(gEnd - gStart));
        int b = (int)((float)bStart + t * (float)(bEnd - bStart));
        int color = a << 24 | r << 16 | g << 8 | b;
        return color;
    }

    public static MutableComponent illageriate(MutableComponent input, double percentage, long seed) {
        return RenderUtils.stylize(input, percentage, Style.EMPTY.withFont(ILLAGER_ALT_FONT), seed);
    }

    public static MutableComponent galactizate(MutableComponent input, double percentage, long seed) {
        return RenderUtils.stylize(input, percentage, Style.EMPTY.withFont(ALT_FONT), seed);
    }

    public static MutableComponent obfuscate(MutableComponent input, double percentage, long seed) {
        return RenderUtils.stylize(input, percentage, Style.EMPTY.withObfuscated(Boolean.valueOf(true)).withColor(ChatFormatting.DARK_RED), seed);
    }

    public static MutableComponent stylize(MutableComponent input, double percentage, Style style, long seed) {
        RandomSource random = RandomSource.create((long)seed);
        String text = input.getString();
        int length = text.length();
        Set indices = IntStream.generate(() -> random.nextInt(length)).distinct().limit((int)((double)length * percentage)).boxed().collect(Collectors.toSet());
        return IntStream.range(0, length).mapToObj(index -> {
            MutableComponent component = Component.literal((String)String.valueOf(text.charAt(index))).setStyle(input.getStyle());
            if (indices.contains(index)) {
                component.setStyle(style.applyTo(component.getStyle()));
            }
            return component;
        }).collect(Component::empty, MutableComponent::append, MutableComponent::append);
    }
}

