/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.access_denied.config;

import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="access_denied", bus=EventBusSubscriber.Bus.MOD)
public class AccessDeniedConfiguration {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.ConfigValue<List<? extends String>> DISABLED_DIMENSIONS = BUILDER.comment(" A list of registry ids of dimensions players cannot travel to at all.").defineListAllowEmpty("disabledDimensions", List.of("minecraft:the_end"), AccessDeniedConfiguration::validateItemName);
    private static final ModConfigSpec.BooleanValue PUSH_BACK_PLAYER = BUILDER.comment("\n Whether to push the player back or not when not meeting the requirements to access a dimension.").define("pushBackPlayer", false);
    private static final ModConfigSpec.BooleanValue CONSUME_ITEMS = BUILDER.comment("\n Whether to consume the items specified in the itemsKey requirement.").define("consumeItems", false);
    private static final ModConfigSpec.ConfigValue<? extends String> ACCESS_DENIED_MESSAGE = BUILDER.comment("\n Message displayed when the player cannot access the dimension.").define("accessDeniedMessage", (Object)"Access Denied!");
    private static final ModConfigSpec.ConfigValue<List<? extends String>> REQUIREMENTS_MESSAGE_BUILDER = BUILDER.comment("\n This is the list of Strings that form the message with the missing requirements. You can modify each part to translate it or change text, but mesculating their order or deleting an entry will break the functionality. If it happens, delete the config file.\nThere will now be a list of the requirements in the order of Strings they appear.\n2. blocksBroken\n3. blocksPlaced\n4. xpLevel\n5. playerKills\n6. mobKills\n7. playTime\n8. itemKeys\n9. effects\n10. health\n11. deaths\n12. chance\n13. advancements\n14. ftbQuestIds\n15. jumps\n16. timesFished").defineList("requirementsMessageBuilder", List.of("You need to:", "Break another %missingBlocksBroken% blocks", "Place another %missingBlocksPlaced% blocks", "Get another %missingXpLevels% experience levels", "Kill another %missingPlayerKills% players", "Kill another %missingMobKills% mobs", "Play for another %missingPlayTime% seconds", "Have the items %missingItems%", "Have the effects %missingEffects%", "Have another %missingHealth% hearts", "Die another %missingDeaths% times", "Try again! You have a %chance% chance", "Complete the advancements %missingAdvancements%", "Complete the Quests %missingFtbQuests%", "Jump another %missingJumps% times", "Fish another %missingFishingCount% times", "Kill another %count% of %mob%", "Break another %count% of %block%", "to enter this dimension."), AccessDeniedConfiguration::validateItemName);
    public static final ModConfigSpec SPEC = BUILDER.build();
    public static List<? extends String> disabledDimensions;
    public static Boolean pushBackPlayer;
    public static Boolean consumeItems;
    public static String accessDeniedMessage;
    public static List<? extends String> requirementsMessageBuilder;

    private static boolean validateItemName(Object obj) {
        boolean bl;
        if (obj instanceof String) {
            String itemName = (String)obj;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() != SPEC) {
            return;
        }
        disabledDimensions = (List)DISABLED_DIMENSIONS.get();
        pushBackPlayer = (Boolean)PUSH_BACK_PLAYER.get();
        consumeItems = (Boolean)CONSUME_ITEMS.get();
        accessDeniedMessage = (String)ACCESS_DENIED_MESSAGE.get();
        requirementsMessageBuilder = (List)REQUIREMENTS_MESSAGE_BUILDER.get();
    }

    @SubscribeEvent
    static void onReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() != SPEC) {
            return;
        }
        disabledDimensions = (List)DISABLED_DIMENSIONS.get();
        pushBackPlayer = (Boolean)PUSH_BACK_PLAYER.get();
        consumeItems = (Boolean)CONSUME_ITEMS.get();
        accessDeniedMessage = (String)ACCESS_DENIED_MESSAGE.get();
        requirementsMessageBuilder = (List)REQUIREMENTS_MESSAGE_BUILDER.get();
    }
}

