/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.access_denied.util;

import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import fox.mods.access_denied.requirements.DimensionRequirementsLoader;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class FtbQuestsHelper {
    public static boolean isQuestCompleted(ServerPlayer player, String stringQuestId) {
        long questId = Long.parseLong(stringQuestId, 16);
        if (!DimensionRequirementsLoader.ftbQuests.booleanValue()) {
            return true;
        }
        BaseQuestFile baseFile = FTBQuestsAPI.api().getQuestFile(false);
        if (!(baseFile instanceof ServerQuestFile)) {
            return false;
        }
        ServerQuestFile serverFile = (ServerQuestFile)baseFile;
        Quest quest = serverFile.getQuest(questId);
        if (quest == null) {
            return false;
        }
        TeamData data = serverFile.getOrCreateTeamData((Entity)player);
        if (data == null) {
            return false;
        }
        return data.isCompleted((QuestObject)quest);
    }

    public static Component getQuestTitle(String stringQuestId) {
        long questId = Long.parseLong(stringQuestId, 16);
        BaseQuestFile baseFile = FTBQuestsAPI.api().getQuestFile(false);
        if (!(baseFile instanceof ServerQuestFile)) {
            return Component.literal((String)"Unknown Quest");
        }
        ServerQuestFile serverFile = (ServerQuestFile)baseFile;
        Quest quest = serverFile.getQuest(questId);
        if (quest == null) {
            return Component.literal((String)("Quest not found (ID: " + questId + ")"));
        }
        String rawTitle = quest.getRawTitle();
        if (rawTitle == null || rawTitle.isEmpty()) {
            return Component.literal((String)("Quest " + stringQuestId));
        }
        return Component.literal((String)rawTitle);
    }
}

