/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.util.biome.BiomeUtil;
import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import terrablender.api.Region;
import terrablender.api.RegionType;

public class BOPNetherRegionCommon
extends Region {
    public static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"nether_common");

    public BOPNetherRegionCommon(int weight) {
        super(LOCATION, RegionType.NETHER, weight);
    }

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addBiome(mapper, Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), 0.0f, Biomes.NETHER_WASTES);
        this.addBiome(mapper, Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)-0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), 0.0f, BiomeUtil.biomeOrFallback(registry, BOPBiomes.CRYSTALLINE_CHASM, Biomes.SOUL_SAND_VALLEY));
        this.addBiome(mapper, Climate.Parameter.point((float)0.4f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), 0.0f, BiomeUtil.biomeOrFallback(registry, BOPBiomes.UNDERGROWTH, Biomes.CRIMSON_FOREST));
        this.addBiome(mapper, Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), 0.375f, BiomeUtil.biomeOrFallback(registry, BOPBiomes.VISCERAL_HEAP, Biomes.WARPED_FOREST));
        this.addBiome(mapper, Climate.Parameter.point((float)-0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), 0.175f, BiomeUtil.biomeOrFallback(registry, BOPBiomes.ERUPTING_INFERNO, Biomes.BASALT_DELTAS));
    }
}

