/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items;

import com.direwolf20.justdirethings.common.entities.TimeWandEntity;
import com.direwolf20.justdirethings.common.fluids.timefluid.TimeFluidBlock;
import com.direwolf20.justdirethings.common.items.interfaces.BasePoweredItem;
import com.direwolf20.justdirethings.common.items.interfaces.FluidContainingItem;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MagicHelpers;
import com.direwolf20.justdirethings.util.MiscTools;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class TimeWand
extends BasePoweredItem
implements PoweredItem,
FluidContainingItem {
    public TimeWand() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!((Boolean)Config.TIME_WAND_FAKE_PLAYER_ALLOWED.get()).booleanValue() && player instanceof FakePlayer) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        BlockHitResult blockhitresult = TimeWand.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() == HitResult.Type.BLOCK) {
            if (TimeWand.pickupFluid(level, player, itemStack, blockhitresult)) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            if (this.spawnEntity(level, player, blockhitresult.getBlockPos(), itemStack)) {
                return InteractionResultHolder.success((Object)itemStack);
            }
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public boolean spawnEntity(Level level, Player player, BlockPos blockPos, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (level.isClientSide) {
            return false;
        }
        BlockState blockState = level.getBlockState(blockPos);
        if (!MiscTools.isValidTickAccelBlock((ServerLevel)level, blockState, blockEntity = level.getBlockEntity(blockPos))) {
            return false;
        }
        int setRate = 1;
        Optional existingEntity = level.getEntitiesOfClass(TimeWandEntity.class, new AABB(blockPos)).stream().findFirst();
        if (existingEntity.isPresent()) {
            TimeWandEntity timeWandEntity = (TimeWandEntity)((Object)existingEntity.get());
            setRate = timeWandEntity.getTickSpeed() + 1;
            if (setRate > Config.logBase2((Integer)Config.TIME_WAND_MAX_MULTIPLIER.get())) {
                return false;
            }
            float accelRate = TimeWandEntity.calculateAccelRate(setRate);
            int cost = TimeWand.calculateFluidCost(player, (int)accelRate);
            int feCost = TimeWand.calculateFECost(player, (int)accelRate);
            if (this.hasResources(player, itemStack, feCost, cost)) {
                timeWandEntity.setTickSpeed(setRate);
                int timeExisted = timeWandEntity.getTotalTime() - timeWandEntity.getRemainingTime();
                int moreTime = timeExisted / 2;
                timeWandEntity.addTime(moreTime);
                FluidContainingItem.consumeFluid(itemStack, cost);
                PoweredItem.consumeEnergy(itemStack, feCost);
                this.playTimeWandSound(level, blockPos, setRate);
                return true;
            }
        } else {
            float accelRate = TimeWandEntity.calculateAccelRate(setRate);
            int cost = TimeWand.calculateFluidCost(player, (int)accelRate);
            int feCost = TimeWand.calculateFECost(player, (int)accelRate);
            if (this.hasResources(player, itemStack, feCost, cost)) {
                TimeWandEntity timeWandEntity = new TimeWandEntity(level, blockPos);
                level.addFreshEntity((Entity)timeWandEntity);
                FluidContainingItem.consumeFluid(itemStack, cost);
                PoweredItem.consumeEnergy(itemStack, feCost);
                this.playTimeWandSound(level, blockPos, setRate);
                return true;
            }
        }
        return false;
    }

    public boolean hasResources(Player player, ItemStack itemStack, int feCost, int fluidCost) {
        float failurePitch = 0.5f;
        if (!FluidContainingItem.hasEnoughFluid(itemStack, fluidCost)) {
            player.displayClientMessage((Component)Component.translatable((String)"justdirethings.lowtimefluid"), true);
            player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE.value(), SoundSource.PLAYERS, 1.0f, failurePitch);
            return false;
        }
        if (!PoweredItem.hasEnoughEnergy(itemStack, feCost)) {
            player.displayClientMessage((Component)Component.translatable((String)"justdirethings.lowenergy"), true);
            player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE.value(), SoundSource.PLAYERS, 1.0f, failurePitch);
            return false;
        }
        return true;
    }

    public static int calculateFECost(Player player, int setRate) {
        if (player.isCreative()) {
            return 0;
        }
        return setRate * TimeWand.getFEPerRate();
    }

    public static int calculateFluidCost(Player player, int setRate) {
        if (player.isCreative()) {
            return 0;
        }
        return (int)((float)setRate * TimeWand.getMBPerRate());
    }

    public static float getMBPerRate() {
        return ((Double)Config.TIMEWAND_FLUID_COST.get()).floatValue();
    }

    public static int getFEPerRate() {
        return (Integer)Config.TIMEWAND_RF_COST.get();
    }

    public static boolean pickupFluid(Level level, Player player, ItemStack itemStack, BlockHitResult blockhitresult) {
        BlockPos blockpos = blockhitresult.getBlockPos();
        BlockState blockstate1 = level.getBlockState(blockpos);
        Block block = blockstate1.getBlock();
        if (block instanceof TimeFluidBlock) {
            TimeFluidBlock timeFluidBlock = (TimeFluidBlock)block;
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidHandler == null) {
                return true;
            }
            int filledAmt = fluidHandler.fill(new FluidStack((Fluid)Registration.TIME_FLUID_SOURCE.get(), 1000), IFluidHandler.FluidAction.SIMULATE);
            if (filledAmt == 1000) {
                ItemStack itemstack2 = timeFluidBlock.pickupBlock(player, (LevelAccessor)level, blockpos, blockstate1);
                fluidHandler.fill(new FluidStack((Fluid)Registration.TIME_FLUID_SOURCE.get(), 1000), IFluidHandler.FluidAction.EXECUTE);
                timeFluidBlock.getPickupSound(blockstate1).ifPresent(p_150709_ -> player.playSound(p_150709_, 1.0f, 1.0f));
                if (!level.isClientSide) {
                    CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemstack2);
                }
            }
            return true;
        }
        return false;
    }

    private void playTimeWandSound(Level serverLevel, BlockPos pos, int setRate) {
        float pitch = switch (setRate) {
            case 1 -> 0.707107f;
            case 2 -> 0.793701f;
            case 3 -> 0.890899f;
            case 4 -> 0.943874f;
            case 5 -> 1.059463f;
            case 6 -> 1.189207f;
            case 7 -> 1.33484f;
            case 8 -> 1.414214f;
            case 9 -> 1.587401f;
            case 10 -> 1.781797f;
            case 11 -> 1.887749f;
            default -> 1.0f;
        };
        serverLevel.playSound(null, pos, (SoundEvent)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE.value(), SoundSource.PLAYERS, 1.0f, pitch);
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)Config.TIME_WAND_RF_CAPACITY.get();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Level level = context.level();
        if (level == null) {
            return;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return;
        }
        tooltip.add((Component)Component.translatable((String)"justdirethings.timefluidamt", (Object[])new Object[]{MagicHelpers.formatted(fluidHandler.getFluidInTank(0).getAmount()), MagicHelpers.formatted(fluidHandler.getTankCapacity(0))}).withStyle(ChatFormatting.GREEN));
    }
}

