/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class WorldIdPacket {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"worldinfo", (String)"world_id");
    public static final StreamCodec<RegistryFriendlyByteBuf, WorldIdPacket> STREAM_CODEC = StreamCodec.ofMember(WorldIdPacket::encode, WorldIdPacket::new);
    private String worldId;

    public WorldIdPacket() {
        this.worldId = "";
    }

    public WorldIdPacket(String worldId) {
        this.worldId = worldId;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public String getWorldId() {
        return this.worldId;
    }

    public WorldIdPacket(FriendlyByteBuf buf) {
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                buf.readByte();
                this.worldId = buf.readUtf(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for worldId: %s", t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            if (this.worldId != null) {
                buf.writeByte(0);
                buf.writeByte(42);
                buf.writeUtf(this.worldId);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for worldId:" + String.valueOf(t));
        }
    }

    public static void handle(PacketContext<WorldIdPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            JourneymapClient.getInstance().getPacketHandler().onWorldIdReceived(((WorldIdPacket)ctx.message()).getWorldId());
        } else {
            Journeymap.getInstance().getPacketHandler().onWorldIdRequest(ctx.sender());
        }
    }
}

