/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.client.gui.screen.widget;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.gui.Widgets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class EnumButton<T extends Enum<T>>
extends Button {
    protected final List<T> states;
    protected final Map<T, WidgetSprites> sprites;
    protected final OnStateChanged<T> onStateChanged;
    protected int currentStateIndex;
    @Nullable
    protected Function<T, Tooltip> tooltipFunc;
    @Nullable
    protected Tooltip defaultTooltip;

    public EnumButton(Class<T> enumClass, int x, int y, int width, int height, ResourceLocation sprite, OnStateChanged<T> onStateChanged, Component message) {
        super(x, y, width, height, message, b -> {}, n -> Component.empty());
        this.states = Arrays.asList((Enum[])enumClass.getEnumConstants());
        this.sprites = new HashMap<T, WidgetSprites>();
        this.onStateChanged = onStateChanged;
        this.currentStateIndex = 0;
        for (Enum state : this.states) {
            String name = state.name().toLowerCase();
            WidgetSprites sprites = Widgets.threeStateSprites((ResourceLocation)sprite.withSuffix("_" + name));
            this.sprites.put(state, sprites);
        }
    }

    public T getState() {
        return (T)((Enum)this.states.get(this.currentStateIndex));
    }

    public void setState(T state) {
        this.setStateIndex(((Enum)state).ordinal());
    }

    public void setStateIndex(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.states.size());
        this.currentStateIndex = index;
    }

    public void changeState(T state) {
        T previousState = this.getState();
        if (!((Enum)previousState).equals(state)) {
            this.setState(state);
            this.onStateChanged.onStateChanged(this, previousState, state);
        }
    }

    public void changeStateIndex(int index) {
        int previousIndex = this.currentStateIndex;
        if (previousIndex != index) {
            this.setStateIndex(index);
            this.onStateChanged.onStateChanged(this, (Enum)this.states.get(previousIndex), (Enum)this.states.get(index));
        }
    }

    public void previousState() {
        this.changeStateIndex((this.currentStateIndex - 1 + this.states.size()) % this.states.size());
    }

    public void nextState() {
        this.changeStateIndex((this.currentStateIndex + 1) % this.states.size());
    }

    public void setDefaultTooltip(@Nullable Tooltip tooltip) {
        this.defaultTooltip = tooltip;
    }

    public void setTooltipFunc(@Nullable Function<T, Tooltip> tooltipFunc) {
        this.tooltipFunc = tooltipFunc;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isHoveredOrFocused()) {
            this.setTooltip(this.tooltipFunc != null ? (Tooltip)this.tooltipFunc.apply(this.getState()) : this.defaultTooltip);
        }
        WidgetSprites sprites = this.sprites.get(this.getState());
        ResourceLocation resourceLocation = sprites.get(this.isActive(), this.isHoveredOrFocused());
        guiGraphics.blitSprite(resourceLocation, this.getX(), this.getY(), this.width, this.height);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isActive() && this.clicked(mouseX, mouseY)) {
            if (button == 1) {
                this.previousState();
            } else {
                this.nextState();
            }
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isActive() && this.clicked(mouseX, mouseY)) {
            if (scrollY < 0.0) {
                this.previousState();
            } else {
                this.nextState();
            }
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isActive() && CommonInputs.selected((int)keyCode)) {
            if (Screen.hasShiftDown()) {
                this.previousState();
            } else {
                this.nextState();
            }
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public static interface OnStateChanged<T extends Enum<T>> {
        public void onStateChanged(EnumButton<T> var1, T var2, T var3);
    }
}

