/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.ae2importexportcard.mixin;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.ids.AEComponents;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.me.helpers.ActionHostEnergySource;
import appeng.me.helpers.MachineSource;
import appeng.me.helpers.PlayerSource;
import appeng.menu.locator.MenuLocators;
import appeng.util.ConfigInventory;
import com.ultramega.ae2importexportcard.AE2ImportExportCard;
import com.ultramega.ae2importexportcard.compat.ae2wtlib.Ae2WtlibUtils;
import com.ultramega.ae2importexportcard.registry.ModDataComponents;
import com.ultramega.ae2importexportcard.registry.ModItems;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WirelessTerminalItem.class})
public abstract class MixinWirelessTerminalItem
extends Item {
    @Unique
    private Future<ICraftingPlan> ae2importExportCard$craftingJob;

    public MixinWirelessTerminalItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (level.isClientSide()) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        IGrid grid = null;
        WirelessTerminalMenuHost host = null;
        Item item = stack.getItem();
        if (item instanceof WirelessTerminalItem) {
            WirelessTerminalMenuHost wirelessTerminalMenuHost;
            WirelessTerminalItem wirelessTerminalItem = (WirelessTerminalItem)item;
            if (AE2ImportExportCard.AE2WTLIB_INSTALLED) {
                grid = Ae2WtlibUtils.getGridFromStack(wirelessTerminalItem, (Player)player, stack);
            }
            if (grid == null) {
                grid = wirelessTerminalItem.getLinkedGrid(stack, level, null);
            }
            if ((wirelessTerminalMenuHost = wirelessTerminalItem.getMenuHost((Player)player, MenuLocators.forStack((ItemStack)stack), null)) instanceof WirelessTerminalMenuHost) {
                WirelessTerminalMenuHost menuHost;
                host = menuHost = wirelessTerminalMenuHost;
            }
        }
        if (grid == null) {
            return;
        }
        ItemContainerContents upgrades = (ItemContainerContents)stack.getOrDefault(AEComponents.UPGRADES, (Object)ItemContainerContents.EMPTY);
        for (int i = 0; i < upgrades.getSlots(); ++i) {
            boolean isExportUpgrade;
            ItemStack upgrade = upgrades.getStackInSlot(i);
            boolean isImportUpgrade = upgrade.getItem() == ModItems.IMPORT_CARD.get();
            boolean bl = isExportUpgrade = upgrade.getItem() == ModItems.EXPORT_CARD.get();
            if (!isImportUpgrade && !isExportUpgrade) continue;
            IConfigManager configManager = IConfigManager.builder((ItemStack)upgrade).registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL).build();
            int[] selectedInventorySlots = ((IntList)upgrade.getOrDefault(ModDataComponents.SELECTED_INVENTORY_SLOTS, (Object)new IntArrayList(new int[36]))).toIntArray();
            IUpgradeInventory upgradeInventory = UpgradeInventories.forItem((ItemStack)upgrade, (int)3, null);
            boolean invertFilter = upgradeInventory.isInstalled((ItemLike)AEItems.INVERTER_CARD);
            FuzzyMode fuzzyMode = (FuzzyMode)configManager.getSetting(Settings.FUZZY_MODE);
            for (int j = 0; j < selectedInventorySlots.length; ++j) {
                if (selectedInventorySlots[j] < 1) continue;
                ItemStack itemInInventory = player.getInventory().getItem(j);
                if (!isExportUpgrade && itemInInventory.getItem() == Items.AIR || itemInInventory == stack) continue;
                ConfigInventory filterConfig = ConfigInventory.configTypes((int)18).changeListener(null).build();
                filterConfig.readFromChildTag((CompoundTag)upgrade.getOrDefault(ModDataComponents.FILTER_CONFIG, (Object)new CompoundTag()), "", (HolderLookup.Provider)player.registryAccess());
                if (host == null) {
                    return;
                }
                IGridNode node = host.getActionableNode();
                if (node == null) {
                    return;
                }
                PlayerSource source = new PlayerSource((Player)player);
                if (isImportUpgrade) {
                    long amount;
                    AEItemKey what = AEItemKey.of((ItemStack)itemInInventory);
                    if (what == null || grid.getStorageService() == null) continue;
                    for (int index = 0; index < filterConfig.size(); ++index) {
                        long amount2;
                        AEFluidKey aeFluidKey;
                        FluidStack fluidStack;
                        IFluidHandlerItem cap;
                        GenericStack filter = filterConfig.getStack(index);
                        if (filter == null || !(filter.what() instanceof AEFluidKey) || (cap = (IFluidHandlerItem)itemInInventory.getCapability(Capabilities.FluidHandler.ITEM)) == null || (fluidStack = cap.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty() || (aeFluidKey = AEFluidKey.of((FluidStack)fluidStack)) == null || (amount2 = StorageHelper.poweredInsert((IEnergySource)new ActionHostEnergySource((IActionHost)host), (MEStorage)grid.getStorageService().getInventory(), (AEKey)aeFluidKey, (long)fluidStack.getAmount(), (IActionSource)source, (Actionable)Actionable.SIMULATE)) <= 0L) continue;
                        cap.drain((int)amount2, IFluidHandler.FluidAction.EXECUTE);
                        StorageHelper.poweredInsert((IEnergySource)new ActionHostEnergySource((IActionHost)host), (MEStorage)grid.getStorageService().getInventory(), (AEKey)aeFluidKey, (long)amount2, (IActionSource)source, (Actionable)Actionable.MODULATE);
                        player.getInventory().setItem(j, cap.getContainer());
                        player.containerMenu.broadcastChanges();
                    }
                    if (invertFilter == filterConfig.getAvailableStacks().findFuzzy((AEKey)what, fuzzyMode).stream().anyMatch(arg_0 -> MixinWirelessTerminalItem.lambda$inventoryTick$0(upgradeInventory, (AEKey)what, fuzzyMode, arg_0)) || (amount = StorageHelper.poweredInsert((IEnergySource)new ActionHostEnergySource((IActionHost)host), (MEStorage)grid.getStorageService().getInventory(), (AEKey)what, (long)itemInInventory.getCount(), (IActionSource)source, (Actionable)Actionable.SIMULATE)) <= 0L) continue;
                    StorageHelper.poweredInsert((IEnergySource)new ActionHostEnergySource((IActionHost)host), (MEStorage)grid.getStorageService().getInventory(), (AEKey)what, (long)itemInInventory.getCount(), (IActionSource)source, (Actionable)Actionable.MODULATE);
                    player.getInventory().setItem(j, ItemStack.EMPTY);
                    player.containerMenu.broadcastChanges();
                    continue;
                }
                for (int index = 0; index < filterConfig.size(); ++index) {
                    int amount;
                    IItemHandler playerInventory;
                    GenericStack filter = filterConfig.getStack(index);
                    if (filter == null || index != selectedInventorySlots[j] - 1 || (playerInventory = (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY)) == null) continue;
                    AEItemKey what = AEItemKey.of((ItemLike)itemInInventory.getItem());
                    boolean acceptsFluid = false;
                    IFluidHandlerItem cap = (IFluidHandlerItem)itemInInventory.getCapability(Capabilities.FluidHandler.ITEM);
                    if (cap != null) {
                        acceptsFluid = true;
                    }
                    if (!acceptsFluid && !itemInInventory.isEmpty() && !(upgradeInventory.isInstalled((ItemLike)AEItems.FUZZY_CARD) ? what.fuzzyEquals(filter.what(), fuzzyMode) : what.equals((Object)filter.what()))) continue;
                    AEKey toExportKey = null;
                    if (upgradeInventory.isInstalled((ItemLike)AEItems.FUZZY_CARD)) {
                        Optional fuzzy = grid.getStorageService().getCachedInventory().findFuzzy(filter.what(), fuzzyMode).stream().findFirst();
                        if (fuzzy.isPresent()) {
                            toExportKey = (AEKey)((Object2LongMap.Entry)fuzzy.get()).getKey();
                        }
                    } else {
                        toExportKey = filter.what();
                    }
                    if (toExportKey == null) continue;
                    if (toExportKey instanceof AEItemKey) {
                        AEItemKey fuzzyItem = (AEItemKey)toExportKey;
                        int extractAmount = Math.min(itemInInventory.getMaxStackSize() - itemInInventory.getCount(), itemInInventory.getMaxStackSize());
                        int stackInteractionSize = upgradeInventory.isInstalled((ItemLike)AEItems.SPEED_CARD) ? 64 : 1;
                        int size = Math.min(stackInteractionSize, extractAmount);
                        if (size <= 0) continue;
                        long extracted = StorageHelper.poweredExtraction((IEnergySource)new ActionHostEnergySource((IActionHost)host), (MEStorage)grid.getStorageService().getInventory(), (AEKey)toExportKey, (long)size, (IActionSource)source, (Actionable)Actionable.SIMULATE);
                        if (extracted <= 0L) {
                            ICraftingService craftingService;
                            if (!upgradeInventory.isInstalled((ItemLike)AEItems.CRAFTING_CARD) || !(craftingService = grid.getCraftingService()).isCraftable(filter.what()) || craftingService.getRequestedAmount(filter.what()) > 0L) continue;
                            MachineSource src = new MachineSource(() -> ((IGrid)grid).getPivot());
                            if (this.ae2importExportCard$craftingJob != null) {
                                try {
                                    ICraftingPlan job = null;
                                    if (this.ae2importExportCard$craftingJob.isDone()) {
                                        job = this.ae2importExportCard$craftingJob.get();
                                    }
                                    if (job != null) {
                                        craftingService.submitJob(job, null, null, false, (IActionSource)src);
                                        this.ae2importExportCard$craftingJob = null;
                                    }
                                }
                                catch (InterruptedException | ExecutionException exception) {
                                    // empty catch block
                                }
                            }
                            this.ae2importExportCard$craftingJob = craftingService.beginCraftingCalculation(level, () -> src, filter.what(), (long)size, CalculationStrategy.CRAFT_LESS);
                            continue;
                        }
                        ItemStack toInsert = fuzzyItem.toStack((int)extracted);
                        ItemStack inserted = playerInventory.insertItem(j, toInsert, true);
                        if (!inserted.isEmpty()) continue;
                        StorageHelper.poweredExtraction((IEnergySource)new ActionHostEnergySource((IActionHost)host), (MEStorage)grid.getStorageService().getInventory(), (AEKey)toExportKey, (long)size, (IActionSource)source, (Actionable)Actionable.MODULATE);
                        playerInventory.insertItem(j, toInsert, false);
                        player.containerMenu.broadcastChanges();
                        continue;
                    }
                    if (!acceptsFluid || !(toExportKey instanceof AEFluidKey)) continue;
                    AEFluidKey fuzzyFluid = (AEFluidKey)toExportKey;
                    int stackInteractionSize = upgradeInventory.isInstalled((ItemLike)AEItems.SPEED_CARD) ? 64000 : 1000;
                    long extracted = StorageHelper.poweredExtraction((IEnergySource)new ActionHostEnergySource((IActionHost)host), (MEStorage)grid.getStorageService().getInventory(), (AEKey)toExportKey, (long)stackInteractionSize, (IActionSource)source, (Actionable)Actionable.SIMULATE);
                    if (extracted <= 0L || (amount = cap.fill(fuzzyFluid.toStack((int)extracted), IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
                    StorageHelper.poweredExtraction((IEnergySource)new ActionHostEnergySource((IActionHost)host), (MEStorage)grid.getStorageService().getInventory(), (AEKey)toExportKey, (long)amount, (IActionSource)source, (Actionable)Actionable.MODULATE);
                    cap.fill(fuzzyFluid.toStack(amount), IFluidHandler.FluidAction.EXECUTE);
                    player.getInventory().setItem(j, cap.getContainer());
                    player.containerMenu.broadcastChanges();
                }
            }
        }
    }

    private static /* synthetic */ boolean lambda$inventoryTick$0(IUpgradeInventory upgradeInventory, AEKey what, FuzzyMode fuzzyMode, Object2LongMap.Entry filterKeyEntry) {
        return upgradeInventory.isInstalled((ItemLike)AEItems.FUZZY_CARD) ? what.fuzzyEquals((AEKey)filterKeyEntry.getKey(), fuzzyMode) : what.equals(filterKeyEntry.getKey());
    }
}

