/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BloomingLeavesBlock
extends LeavesBlock {
    public static final BooleanProperty BLOOMING = BooleanProperty.create((String)"blooming");

    public BloomingLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BLOOMING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BLOOMING});
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (itemStack.is(Items.SHEARS) && ((Boolean)state.getValue((Property)BLOOMING)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BLOOMING, (Comparable)Boolean.valueOf(false)), 2);
            if (!player.isCreative()) {
                itemStack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (itemStack.is(ItemTags.SMALL_FLOWERS) && !((Boolean)state.getValue((Property)BLOOMING)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BLOOMING, (Comparable)Boolean.valueOf(true)), 2);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)BLOOMING) != false ? 1.0f : 0.8f;
    }
}

