/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CattailBlock
extends TallFlowerBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<TallFlowerBlock> CODEC = CattailBlock.simpleCodec(CattailBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public CattailBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public MapCodec<TallFlowerBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, WATERLOGGED});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return super.canSurvive(state, level, pos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos clickedPos = ctx.getClickedPos();
        if (clickedPos.getY() >= ctx.getLevel().getMaxBuildHeight() - 1) {
            return null;
        }
        if (!ctx.getLevel().getBlockState(clickedPos.above()).canBeReplaced(ctx)) {
            return null;
        }
        BlockState base = super.getStateForPlacement(ctx);
        if (base == null) {
            return null;
        }
        boolean isWaterHere = ctx.getLevel().getFluidState(clickedPos).getType() == Fluids.WATER;
        return (BlockState)base.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterHere));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos fromPos) {
        BlockState result = super.updateShape(state, direction, neighbor, level, pos, fromPos);
        if (result.getBlock() != this) {
            return result;
        }
        if (!result.hasProperty((Property)WATERLOGGED) || !state.hasProperty((Property)WATERLOGGED)) {
            return result;
        }
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            if (direction == Direction.DOWN && neighbor.getBlock() == this && neighbor.hasProperty((Property)WATERLOGGED)) {
                boolean lowerWaterlogged = (Boolean)neighbor.getValue((Property)WATERLOGGED);
                if ((Boolean)result.getValue((Property)WATERLOGGED) != lowerWaterlogged) {
                    return (BlockState)result.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(lowerWaterlogged));
                }
            }
            return result;
        }
        return result;
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return super.mayPlaceOn(floor, world, pos) || floor.is(BlockTags.SAND) || floor.is(Blocks.CLAY) || floor.is(Blocks.GRASS_BLOCK) || floor.is(Blocks.COARSE_DIRT) || floor.is(Blocks.DIRT) || floor.is(Blocks.MUD);
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(state);
    }
}

