/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.block;

import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class ExtendedLeavesBlock
extends LeavesBlock {
    public static final IntegerProperty DISTANCE_11 = IntegerProperty.create((String)"distance_11", (int)1, (int)11);

    public ExtendedLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE_11, (Comparable)Integer.valueOf(11))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static BlockState updateDistance(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        int i = 11;
        BlockPos.MutableBlockPos blockpos$autocloseable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$autocloseable.setWithOffset((Vec3i)pPos, direction);
            i = Math.min(i, ExtendedLeavesBlock.getDistanceAt(pLevel.getBlockState((BlockPos)blockpos$autocloseable)) + 1);
            if (i == 1) break;
        }
        return (BlockState)pState.setValue((Property)DISTANCE_11, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState blockState) {
        return ExtendedLeavesBlock.getOptionalDistanceAt(blockState).orElse(11);
    }

    @NotNull
    public static OptionalInt getOptionalDistanceAt(BlockState blockState) {
        if (blockState.is(BlockTags.LOGS)) {
            return OptionalInt.of(0);
        }
        return blockState.hasProperty((Property)DISTANCE_11) ? OptionalInt.of((Integer)blockState.getValue((Property)DISTANCE_11)) : OptionalInt.empty();
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)DISTANCE_11) == 11 && (Boolean)state.getValue((Property)PERSISTENT) == false;
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (this.decaying(blockState)) {
            LeavesBlock.dropResources((BlockState)blockState, (Level)serverLevel, (BlockPos)blockPos);
            serverLevel.removeBlock(blockPos, false);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{DISTANCE_11});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        BlockState blockstate = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        return ExtendedLeavesBlock.updateDistance(blockstate, (LevelAccessor)pContext.getLevel(), pContext.getClickedPos());
    }

    protected boolean decaying(BlockState pState) {
        return (Boolean)pState.getValue((Property)PERSISTENT) == false && (Integer)pState.getValue((Property)DISTANCE_11) == 11;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.setBlock(pPos, ExtendedLeavesBlock.updateDistance(pState, (LevelAccessor)pLevel, pPos), 3);
    }

    @NotNull
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        int i;
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        if ((i = ExtendedLeavesBlock.getDistanceAt(pFacingState) + 1) != 1 || (Integer)pState.getValue((Property)DISTANCE_11) != i) {
            pLevel.scheduleTick(pCurrentPos, (Block)this, 1);
        }
        return pState;
    }
}

