/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.Vec3;
import net.satisfy.bloomingnature.core.world.feature.configured.ConfiguredFeatures;

public class FenMossBlock
extends Block
implements BonemealableBlock {
    public FenMossBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return levelReader.getBlockState(blockPos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        serverLevel.registryAccess().registry(Registries.CONFIGURED_FEATURE).flatMap(registry -> registry.getHolder(ConfiguredFeatures.BOG_MOSS_PATCH_BONEMEAL_KEY)).ifPresent(reference -> ((ConfiguredFeature)reference.value()).place((WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), randomSource, blockPos.above()));
        int conversions = 1 + randomSource.nextInt(5);
        int attempts = conversions * 8;
        for (int i = 0; i < attempts && conversions > 0; ++i) {
            int offsetZ;
            int offsetX = randomSource.nextInt(5) - 2;
            BlockPos targetPos = blockPos.offset(offsetX, 0, offsetZ = randomSource.nextInt(5) - 2);
            BlockState targetState = serverLevel.getBlockState(targetPos);
            if (!targetState.is(Blocks.DIRT) && !targetState.is(Blocks.COARSE_DIRT)) continue;
            serverLevel.setBlock(targetPos, Blocks.CLAY.defaultBlockState(), 2);
            --conversions;
        }
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return true;
    }

    public void randomTick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        if (randomSource.nextInt(20) != 0) {
            return;
        }
        BlockPos belowPos = blockPos.below();
        BlockState belowState = level.getBlockState(belowPos);
        if (belowState.is(Blocks.DIRT) || belowState.is(Blocks.COARSE_DIRT)) {
            level.setBlock(belowPos, Blocks.CLAY.defaultBlockState(), 2);
        }
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(world, state, pos, entity, fallDistance * 0.5f);
    }

    public void updateEntityAfterFallOn(BlockGetter world, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(world, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 motion = entity.getDeltaMovement();
        if (motion.y < 0.0) {
            double bounceFactor = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(motion.x, -motion.y * 0.66 * bounceFactor, motion.z);
        }
    }
}

