/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.satisfy.bloomingnature.core.world.feature.configured.ConfiguredFeatures;

public class ForestMossBlock
extends Block
implements BonemealableBlock {
    public ForestMossBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return levelReader.getBlockState(blockPos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        serverLevel.registryAccess().registry(Registries.CONFIGURED_FEATURE).flatMap(registry -> registry.getHolder(ConfiguredFeatures.FOREST_MOSS_PATCH_BONEMEAL_KEY)).ifPresent(reference -> ((ConfiguredFeature)reference.value()).place((WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), randomSource, blockPos.above()));
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return true;
    }

    public void randomTick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        BlockState mushroomState;
        if (!level.getBiome(blockPos).is(BiomeTags.IS_TAIGA)) {
            return;
        }
        if (randomSource.nextInt(8) != 0) {
            return;
        }
        BlockPos targetPos = blockPos.above();
        if (!level.getBlockState(targetPos).isAir()) {
            return;
        }
        if (level.getMaxLocalRawBrightness(targetPos) >= 9) {
            return;
        }
        BlockState blockState2 = mushroomState = randomSource.nextBoolean() ? Blocks.BROWN_MUSHROOM.defaultBlockState() : Blocks.RED_MUSHROOM.defaultBlockState();
        if (mushroomState.canSurvive((LevelReader)level, targetPos)) {
            level.setBlock(targetPos, mushroomState, 2);
        }
    }

    public void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (!level.isClientSide && entity instanceof LivingEntity) {
            boolean isStandingStill;
            LivingEntity livingEntity = (LivingEntity)entity;
            boolean bl = isStandingStill = livingEntity.getX() == livingEntity.xOld && livingEntity.getZ() == livingEntity.zOld;
            if (isStandingStill && level.random.nextInt(80) == 0) {
                livingEntity.heal(1.0f);
            }
            if (livingEntity.isOnFire() && level.random.nextInt(40) == 0) {
                livingEntity.clearFire();
            }
            if (livingEntity.fallDistance > 3.0f) {
                livingEntity.fallDistance *= 0.5f;
            }
        }
    }

    public void fallOn(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float fallDistance) {
        entity.causeFallDamage(fallDistance, 0.5f, level.damageSources().fall());
    }
}

