/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.block;

import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.bloomingnature.core.block.entity.SunflowerBlockEntity;
import net.satisfy.bloomingnature.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SunflowerBlock
extends DoublePlantBlock
implements BonemealableBlock,
EntityBlock {
    public static final EnumProperty<Phase> PHASE = EnumProperty.create((String)"phase", Phase.class);

    public SunflowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(PHASE, (Comparable)((Object)Phase.DAY)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, PHASE});
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (!level.isClientSide && state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            Phase currentPhase = SunflowerBlock.getCurrentPhase(level);
            level.setBlock(pos, (BlockState)state.setValue(PHASE, (Comparable)((Object)currentPhase)), 3);
            BlockPos belowPos = pos.below();
            BlockState belowState = level.getBlockState(belowPos);
            if (belowState.getBlock() == this) {
                level.setBlock(belowPos, (BlockState)belowState.setValue(PHASE, (Comparable)((Object)currentPhase)), 3);
            }
        }
    }

    public static Phase getCurrentPhase(Level level) {
        long time = level.dayTime() % 24000L;
        if (time < 0L) {
            time = 0L;
        }
        if (level.dimension() != Level.OVERWORLD) {
            return Phase.DAY;
        }
        if (level.isNight()) {
            return Phase.NIGHT;
        }
        if (time < 2000L) {
            return Phase.MORNING;
        }
        if (time < 7000L) {
            return Phase.DAY;
        }
        if (time < 13000L) {
            return Phase.EVENING;
        }
        return Phase.NIGHT;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return false;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return blockState.getValue((Property)HALF) == DoubleBlockHalf.UPPER;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos blockPos, BlockState blockState) {
        return blockState.getValue((Property)HALF) == DoubleBlockHalf.UPPER;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos blockPos, BlockState blockState) {
        ItemStack drop = new ItemStack((ItemLike)this.asItem(), 1 + random.nextInt(2));
        SunflowerBlock.popResource((Level)level, (BlockPos)blockPos, (ItemStack)drop);
    }

    @NotNull
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SunflowerBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return null;
        }
        if (blockState.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
            return null;
        }
        if (blockEntityType != EntityTypeRegistry.SUNFLOWER.get()) {
            return null;
        }
        return (lvl, pos, state, be) -> SunflowerBlockEntity.tick(lvl, pos, state, (SunflowerBlockEntity)be);
    }

    public static enum Phase implements StringRepresentable
    {
        MORNING,
        DAY,
        EVENING,
        NIGHT;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

