/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.satisfy.bloomingnature.core.entity.ModBoatEntity;
import net.satisfy.bloomingnature.core.entity.ModChestBoatEntity;
import org.jetbrains.annotations.NotNull;

public class ModBoatItem
extends BoatItem {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final ModBoatEntity.Type type;
    private final boolean hasChest;

    public ModBoatItem(boolean hasChest, ModBoatEntity.Type type, Item.Properties pProperties) {
        super(hasChest, null, pProperties);
        this.hasChest = hasChest;
        this.type = type;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        BlockHitResult hitresult = ModBoatItem.getPlayerPOVHitResult((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 vec3 = pPlayer.getViewVector(1.0f);
        List list = pLevel.getEntities((Entity)pPlayer, pPlayer.getBoundingBox().expandTowards(vec3.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = pPlayer.getEyePosition();
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!aabb.contains(vec31)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            ModBoatEntity boat = this.getBoat(pLevel, (HitResult)hitresult);
            boat.setWoodType(this.type);
            boat.setYRot(pPlayer.getYRot());
            if (!pLevel.noCollision((Entity)boat, boat.getBoundingBox())) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!pLevel.isClientSide) {
                pLevel.addFreshEntity((Entity)boat);
                pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.ENTITY_PLACE, hitresult.getLocation());
                if (!pPlayer.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)pLevel.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    private ModBoatEntity getBoat(Level level, HitResult hitResult) {
        return this.hasChest ? new ModChestBoatEntity(level, hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z) : new ModBoatEntity(level, hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z);
    }
}

