/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.bloomingnature.BloomingNature;
import net.satisfy.bloomingnature.core.block.entity.CompletionistBannerEntity;
import net.satisfy.bloomingnature.core.block.entity.ModHangingSignBlockEntity;
import net.satisfy.bloomingnature.core.block.entity.ModSignBlockEntity;
import net.satisfy.bloomingnature.core.block.entity.SunflowerBlockEntity;
import net.satisfy.bloomingnature.core.entity.ModBoatEntity;
import net.satisfy.bloomingnature.core.entity.ModChestBoatEntity;
import net.satisfy.bloomingnature.core.entity.WanderingGardenerEntity;
import net.satisfy.bloomingnature.core.registry.ObjectRegistry;
import net.satisfy.bloomingnature.platform.PlatformHelper;

public class EntityTypeRegistry {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"bloomingnature", (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"bloomingnature", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<EntityType<WanderingGardenerEntity>> WANDERING_GARDENER = EntityTypeRegistry.registerEntityType("wandering_gardener", () -> EntityType.Builder.of(WanderingGardenerEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.95f).clientTrackingRange(10).build(BloomingNature.identifier("wandering_gardener").toString()));
    public static final Supplier<EntityType<ModBoatEntity>> MOD_BOAT = PlatformHelper.registerBoatType("mod_boat", ModBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);
    public static final Supplier<EntityType<ModChestBoatEntity>> MOD_CHEST_BOAT = PlatformHelper.registerBoatType("mod_chest_boat", ModChestBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> BLOOMINGNATURE_BANNER = EntityTypeRegistry.registerBlockEntity("bloomingnature_banner", () -> BlockEntityType.Builder.of(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BLOOMINGNATURE_BANNER.get(), (Block)ObjectRegistry.BLOOMINGNATURE_WALL_BANNER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<SunflowerBlockEntity>> SUNFLOWER = EntityTypeRegistry.registerBlockEntity("sunflower", () -> BlockEntityType.Builder.of(SunflowerBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SUNFLOWER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<ModSignBlockEntity>> MOD_SIGN = BLOCK_ENTITY_TYPES.register("mod_sign", () -> BlockEntityType.Builder.of(ModSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.LARCH_SIGN.get(), (Block)ObjectRegistry.LARCH_WALL_SIGN.get(), (Block)ObjectRegistry.ASPEN_SIGN.get(), (Block)ObjectRegistry.ASPEN_WALL_SIGN.get(), (Block)ObjectRegistry.BAOBAB_SIGN.get(), (Block)ObjectRegistry.BAOBAB_WALL_SIGN.get(), (Block)ObjectRegistry.EBONY_SIGN.get(), (Block)ObjectRegistry.EBONY_WALL_SIGN.get(), (Block)ObjectRegistry.CHESTNUT_SIGN.get(), (Block)ObjectRegistry.CHESTNUT_WALL_SIGN.get(), (Block)ObjectRegistry.SWAMP_OAK_SIGN.get(), (Block)ObjectRegistry.SWAMP_OAK_WALL_SIGN.get(), (Block)ObjectRegistry.SWAMP_CYPRESS_SIGN.get(), (Block)ObjectRegistry.SWAMP_CYPRESS_WALL_SIGN.get(), (Block)ObjectRegistry.FAN_PALM_SIGN.get(), (Block)ObjectRegistry.FAN_PALM_WALL_SIGN.get(), (Block)ObjectRegistry.FIR_SIGN.get(), (Block)ObjectRegistry.FIR_WALL_SIGN.get(), (Block)ObjectRegistry.CYPRESS_SIGN.get(), (Block)ObjectRegistry.CYPRESS_WALL_SIGN.get(), (Block)ObjectRegistry.CACTUS_SIGN.get(), (Block)ObjectRegistry.CACTUS_WALL_SIGN.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<ModHangingSignBlockEntity>> MOD_HANGING_SIGN = BLOCK_ENTITY_TYPES.register("mod_hanging_sign", () -> BlockEntityType.Builder.of(ModHangingSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.LARCH_HANGING_SIGN.get(), (Block)ObjectRegistry.LARCH_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.ASPEN_HANGING_SIGN.get(), (Block)ObjectRegistry.ASPEN_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.BAOBAB_HANGING_SIGN.get(), (Block)ObjectRegistry.BAOBAB_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.EBONY_HANGING_SIGN.get(), (Block)ObjectRegistry.EBONY_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.CHESTNUT_HANGING_SIGN.get(), (Block)ObjectRegistry.CHESTNUT_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.SWAMP_OAK_HANGING_SIGN.get(), (Block)ObjectRegistry.SWAMP_OAK_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.SWAMP_CYPRESS_HANGING_SIGN.get(), (Block)ObjectRegistry.SWAMP_CYPRESS_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.FAN_PALM_HANGING_SIGN.get(), (Block)ObjectRegistry.FAN_PALM_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.FIR_HANGING_SIGN.get(), (Block)ObjectRegistry.FIR_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.CYPRESS_HANGING_SIGN.get(), (Block)ObjectRegistry.CYPRESS_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.CACTUS_HANGING_SIGN.get(), (Block)ObjectRegistry.CACTUS_WALL_HANGING_SIGN.get()}).build(null));

    private static <T extends EntityType<?>> RegistrySupplier<T> registerEntityType(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(BloomingNature.identifier(path), type);
    }

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(BloomingNature.identifier(path), type);
    }

    static void registerAttributes() {
        EntityAttributeRegistry.register(WANDERING_GARDENER, Mob::createMobAttributes);
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITY_TYPES.register();
        EntityTypeRegistry.registerAttributes();
    }
}

