/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.biome.arid;

import com.terraformersmc.biolith.api.biome.BiomePlacement;
import com.terraformersmc.biolith.api.biome.sub.BiomeParameterTargets;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.api.biome.sub.CriterionBuilder;
import com.terraformersmc.biolith.api.biome.sub.RatioTargets;
import com.terraformersmc.biolith.api.surface.BiolithSurfaceBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;
import net.satisfy.bloomingnature.core.world.biome.BloomingNatureBiomeKeys;

public final class AridBiomeRegistry
extends BiolithSurfaceBuilder {
    public static void registerBiomePlacement() {
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.PLAINS, BloomingNatureBiomeKeys.CYPRESS_FIELDS, (double)0.28);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.SUNFLOWER_PLAINS, BloomingNatureBiomeKeys.CYPRESS_FIELDS, (double)0.24);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.SAVANNA, BloomingNatureBiomeKeys.BRUSHLANDS, (double)0.16);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.SAVANNA_PLATEAU, BloomingNatureBiomeKeys.BRUSHLANDS, (double)0.22);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.DESERT, BloomingNatureBiomeKeys.BRUSHLANDS, (double)0.22);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.BADLANDS, BloomingNatureBiomeKeys.BRUSHLANDS, (double)0.22);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.SAVANNA, BloomingNatureBiomeKeys.BAOBAB_SAVANNA, (double)0.55);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.SAVANNA_PLATEAU, BloomingNatureBiomeKeys.BAOBAB_SAVANNA, (double)0.65);
        AridBiomeRegistry.registerBaobabSavannaPlacement();
        AridBiomeRegistry.registerDesertRiverPlacement();
        AridBiomeRegistry.registerOasisPlacement();
        AridBiomeRegistry.registerCypressFieldsPlacement();
    }

    private static void registerBaobabSavannaPlacement() {
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.SAVANNA, BloomingNatureBiomeKeys.BAOBAB_SAVANNA, (double)0.4);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.SAVANNA_PLATEAU, BloomingNatureBiomeKeys.BAOBAB_SAVANNA, (double)0.4);
        BiomePlacement.replaceOverworld((ResourceKey)Biomes.WINDSWEPT_SAVANNA, BloomingNatureBiomeKeys.BAOBAB_SAVANNA, (double)0.4);
    }

    private static void registerDesertRiverPlacement() {
        Criterion nearArid = CriterionBuilder.anyOf((Criterion[])new Criterion[]{CriterionBuilder.neighbor((ResourceKey)Biomes.DESERT), CriterionBuilder.neighbor((ResourceKey)Biomes.BADLANDS), CriterionBuilder.neighbor((ResourceKey)Biomes.ERODED_BADLANDS), CriterionBuilder.neighbor((ResourceKey)Biomes.WOODED_BADLANDS)});
        Criterion warm = CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)0.45f, (float)2.0f);
        Criterion shallow = CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.DEPTH, (float)-0.35f, (float)0.25f);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.RIVER, BloomingNatureBiomeKeys.DESERT_RIVER, (Criterion)CriterionBuilder.allOf((Criterion[])new Criterion[]{nearArid, warm, shallow}));
    }

    private static void registerOasisPlacement() {
        Criterion center = CriterionBuilder.ratio((RatioTargets)RatioTargets.CENTER, (float)0.45f, (float)0.55f);
        Criterion depth = CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.DEPTH, (float)-0.2f, (float)0.1f);
        Criterion temp = CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)0.9f, (float)2.0f);
        Criterion cond = CriterionBuilder.allOf((Criterion[])new Criterion[]{center, depth, temp});
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.DESERT, BloomingNatureBiomeKeys.DESERT_OASIS, (Criterion)cond);
    }

    private static void registerCypressFieldsPlacement() {
        Criterion warmTemperature = CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.TEMPERATURE, (float)0.55f, (float)2.0f);
        Criterion depth = CriterionBuilder.value((BiomeParameterTargets)BiomeParameterTargets.DEPTH, (float)-0.2f, (float)0.35f);
        Criterion nearColdBiomes = CriterionBuilder.anyOf((Criterion[])new Criterion[]{CriterionBuilder.neighbor((ResourceKey)Biomes.SNOWY_PLAINS), CriterionBuilder.neighbor((ResourceKey)Biomes.GROVE), CriterionBuilder.neighbor((ResourceKey)Biomes.SNOWY_SLOPES), CriterionBuilder.neighbor((ResourceKey)Biomes.FROZEN_PEAKS), CriterionBuilder.neighbor((ResourceKey)Biomes.JAGGED_PEAKS)});
        Criterion cypressCondition = CriterionBuilder.allOf((Criterion[])new Criterion[]{warmTemperature, depth, CriterionBuilder.not((Criterion)nearColdBiomes)});
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.SAVANNA, BloomingNatureBiomeKeys.CYPRESS_FIELDS, (Criterion)cypressCondition);
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.SAVANNA_PLATEAU, BloomingNatureBiomeKeys.CYPRESS_FIELDS, (Criterion)cypressCondition);
    }
}

